/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.api.client.util.Maps;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskExistsException;
import io.druid.indexing.overlord.TaskLockbox;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.indexing.overlord.config.TaskQueueConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.Duration;

public class TaskQueue {
    private final List<Task> tasks = Lists.newArrayList();
    private final Map<String, ListenableFuture<TaskStatus>> taskFutures = Maps.newHashMap();
    private final TaskQueueConfig config;
    private final TaskStorage taskStorage;
    private final TaskRunner taskRunner;
    private final TaskActionClientFactory taskActionClientFactory;
    private final TaskLockbox taskLockbox;
    private final ServiceEmitter emitter;
    private final ReentrantLock giant = new ReentrantLock();
    private final Condition managementMayBeNecessary = this.giant.newCondition();
    private final ExecutorService managerExec = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(false).setNameFormat("TaskQueue-Manager").build());
    private final ScheduledExecutorService storageSyncExec = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(false).setNameFormat("TaskQueue-StorageSync").build());
    private volatile boolean active = false;
    private static final EmittingLogger log = new EmittingLogger(TaskQueue.class);

    @Inject
    public TaskQueue(TaskQueueConfig config, TaskStorage taskStorage, TaskRunner taskRunner, TaskActionClientFactory taskActionClientFactory, TaskLockbox taskLockbox, ServiceEmitter emitter) {
        this.config = (TaskQueueConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.taskStorage = (TaskStorage)Preconditions.checkNotNull((Object)taskStorage, (Object)"taskStorage");
        this.taskRunner = (TaskRunner)Preconditions.checkNotNull((Object)taskRunner, (Object)"taskRunner");
        this.taskActionClientFactory = (TaskActionClientFactory)Preconditions.checkNotNull((Object)taskActionClientFactory, (Object)"taskActionClientFactory");
        this.taskLockbox = (TaskLockbox)Preconditions.checkNotNull((Object)taskLockbox, (Object)"taskLockbox");
        this.emitter = (ServiceEmitter)Preconditions.checkNotNull((Object)emitter, (Object)"emitter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        this.giant.lock();
        try {
            Preconditions.checkState((!this.active ? 1 : 0) != 0, (Object)"queue must be stopped");
            this.active = true;
            this.syncFromStorage();
            this.managerExec.submit(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            TaskQueue.this.manage();
                        }
                        catch (InterruptedException e) {
                            log.info("Interrupted, exiting!", new Object[0]);
                        }
                        catch (Exception e) {
                            long restartDelay = TaskQueue.this.config.getRestartDelay().getMillis();
                            log.makeAlert((Throwable)e, "Failed to manage", new Object[0]).addData("restartDelay", (Object)restartDelay).emit();
                            try {
                                Thread.sleep(restartDelay);
                            }
                            catch (InterruptedException e2) {
                                log.info("Interrupted, exiting!", new Object[0]);
                                break;
                            }
                        }
                    }
                }
            });
            ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.storageSyncExec, (Duration)this.config.getStorageSyncRate(), (Callable)new Callable<ScheduledExecutors.Signal>(){

                @Override
                public ScheduledExecutors.Signal call() {
                    block3: {
                        try {
                            TaskQueue.this.syncFromStorage();
                        }
                        catch (Exception e) {
                            if (!TaskQueue.this.active) break block3;
                            log.makeAlert((Throwable)e, "Failed to sync with storage", new Object[0]).emit();
                        }
                    }
                    if (TaskQueue.this.active) {
                        return ScheduledExecutors.Signal.REPEAT;
                    }
                    return ScheduledExecutors.Signal.STOP;
                }
            });
            this.managementMayBeNecessary.signalAll();
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        this.giant.lock();
        try {
            this.tasks.clear();
            this.taskFutures.clear();
            this.active = false;
            this.managerExec.shutdownNow();
            this.storageSyncExec.shutdownNow();
            this.managementMayBeNecessary.signalAll();
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manage() throws InterruptedException {
        log.info("Beginning management in %s.", new Object[]{this.config.getStartDelay()});
        Thread.sleep(this.config.getStartDelay().getMillis());
        while (this.active) {
            this.giant.lock();
            try {
                HashMap runnerTaskFutures = Maps.newHashMap();
                for (TaskRunnerWorkItem taskRunnerWorkItem : this.taskRunner.getKnownTasks()) {
                    runnerTaskFutures.put(taskRunnerWorkItem.getTaskId(), taskRunnerWorkItem.getResult());
                }
                for (Task task : ImmutableList.copyOf(this.tasks)) {
                    ListenableFuture<TaskStatus> runnerTaskFuture;
                    if (this.taskFutures.containsKey(task.getId())) continue;
                    if (runnerTaskFutures.containsKey(task.getId())) {
                        runnerTaskFuture = (ListenableFuture<TaskStatus>)runnerTaskFutures.get(task.getId());
                    } else {
                        boolean taskIsReady;
                        try {
                            taskIsReady = task.isReady(this.taskActionClientFactory.create(task));
                        }
                        catch (Exception e) {
                            log.warn((Throwable)e, "Exception thrown during isReady for task: %s", new Object[]{task.getId()});
                            this.notifyStatus(task, TaskStatus.failure(task.getId()));
                            continue;
                        }
                        if (!taskIsReady) continue;
                        log.info("Asking taskRunner to run: %s", new Object[]{task.getId()});
                        runnerTaskFuture = this.taskRunner.run(task);
                    }
                    this.taskFutures.put(task.getId(), this.attachCallbacks(task, runnerTaskFuture));
                }
                Sets.SetView tasksToKill = Sets.difference(runnerTaskFutures.keySet(), (Set)ImmutableSet.copyOf((Collection)Lists.transform(this.tasks, (Function)new Function<Task, Object>(){

                    public String apply(Task task) {
                        return task.getId();
                    }
                })));
                if (!tasksToKill.isEmpty()) {
                    log.info("Asking taskRunner to clean up %,d tasks.", new Object[]{tasksToKill.size()});
                    for (String taskId : tasksToKill) {
                        try {
                            this.taskRunner.shutdown(taskId);
                        }
                        catch (Exception e) {
                            log.warn((Throwable)e, "TaskRunner failed to clean up task: %s", new Object[]{taskId});
                        }
                    }
                }
                this.managementMayBeNecessary.awaitNanos(60000000000L);
            }
            finally {
                this.giant.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Task task) throws TaskExistsException {
        this.giant.lock();
        try {
            Preconditions.checkState((boolean)this.active, (Object)"Queue is not active!");
            Preconditions.checkNotNull((Object)task, (Object)"task");
            Preconditions.checkState((this.tasks.size() < this.config.getMaxSize() ? 1 : 0) != 0, (String)"Too many tasks (max = %,d)", (Object[])new Object[]{this.config.getMaxSize()});
            this.taskStorage.insert(task, TaskStatus.running(task.getId()));
            this.tasks.add(task);
            this.managementMayBeNecessary.signalAll();
            boolean bl = true;
            return bl;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String taskId) {
        this.giant.lock();
        try {
            Preconditions.checkNotNull((Object)taskId, (Object)"taskId");
            for (Task task : this.tasks) {
                if (!task.getId().equals(taskId)) continue;
                this.notifyStatus(task, TaskStatus.failure(taskId));
                break;
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStatus(Task task, TaskStatus taskStatus) {
        block12: {
            this.giant.lock();
            try {
                Preconditions.checkNotNull((Object)task, (Object)"task");
                Preconditions.checkNotNull((Object)taskStatus, (Object)"status");
                Preconditions.checkState((boolean)this.active, (Object)"Queue is not active!");
                Preconditions.checkArgument((boolean)task.getId().equals(taskStatus.getId()), (String)"Mismatching task ids[%s/%s]", (Object[])new Object[]{task.getId(), taskStatus.getId()});
                try {
                    this.taskRunner.shutdown(task.getId());
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "TaskRunner failed to cleanup task after completion: %s", new Object[]{task.getId()});
                }
                int removed = 0;
                for (int i = this.tasks.size() - 1; i >= 0; --i) {
                    if (!this.tasks.get(i).getId().equals(task.getId())) continue;
                    ++removed;
                    this.tasks.remove(i);
                    break;
                }
                if (removed == 0) {
                    log.warn("Unknown task completed: %s", new Object[]{task.getId()});
                } else if (removed > 1) {
                    log.makeAlert("Removed multiple copies of task", new Object[0]).addData("count", (Object)removed).addData("task", (Object)task.getId()).emit();
                }
                this.taskFutures.remove(task.getId());
                if (removed <= 0) break block12;
                try {
                    Optional<TaskStatus> previousStatus = this.taskStorage.getStatus(task.getId());
                    if (!previousStatus.isPresent() || !((TaskStatus)previousStatus.get()).isRunnable()) {
                        log.makeAlert("Ignoring notification for already-complete task", new Object[0]).addData("task", (Object)task.getId()).emit();
                        break block12;
                    }
                    this.taskStorage.setStatus(taskStatus);
                    this.taskLockbox.unlock(task);
                    log.info("Task done: %s", new Object[]{task});
                    this.managementMayBeNecessary.signalAll();
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to persist status for task", new Object[0]).addData("task", (Object)task.getId()).addData("statusCode", (Object)taskStatus.getStatusCode()).emit();
                }
            }
            finally {
                this.giant.unlock();
            }
        }
    }

    private ListenableFuture<TaskStatus> attachCallbacks(final Task task, ListenableFuture<TaskStatus> statusFuture) {
        final ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder().setUser2(task.getDataSource()).setUser4(task.getType());
        Futures.addCallback(statusFuture, (FutureCallback)new FutureCallback<TaskStatus>(){

            public void onSuccess(TaskStatus status) {
                log.info("Received %s status for task: %s", new Object[]{status.getStatusCode(), status.getId()});
                this.handleStatus(status);
            }

            public void onFailure(Throwable t) {
                log.makeAlert(t, "Failed to run task", new Object[0]).addData("task", (Object)task.getId()).addData("type", (Object)task.getType()).addData("dataSource", (Object)task.getDataSource()).emit();
                this.handleStatus(TaskStatus.failure(task.getId()));
            }

            private void handleStatus(TaskStatus status) {
                try {
                    if (!TaskQueue.this.active) {
                        log.info("Abandoning task due to shutdown: %s", new Object[]{task.getId()});
                        return;
                    }
                    TaskQueue.this.notifyStatus(task, status);
                    if (status.isComplete()) {
                        metricBuilder.setUser3(status.getStatusCode().toString());
                        TaskQueue.this.emitter.emit(metricBuilder.build("indexer/time/run/millis", (Number)status.getDuration()));
                        log.info("Task %s: %s (%d run duration)", new Object[]{status.getStatusCode(), task, status.getDuration()});
                    }
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to handle task status", new Object[0]).addData("task", (Object)task.getId()).addData("statusCode", (Object)status.getStatusCode()).emit();
                }
            }
        });
        return statusFuture;
    }

    private void syncFromStorage() {
        this.giant.lock();
        try {
            if (this.active) {
                List<Task> newTasks = this.taskStorage.getActiveTasks();
                log.info("Synced %,d tasks from storage (%,d tasks added, %,d tasks removed).", new Object[]{newTasks.size(), Sets.difference((Set)Sets.newHashSet(newTasks), (Set)Sets.newHashSet(this.tasks)).size(), Sets.difference((Set)Sets.newHashSet(this.tasks), (Set)Sets.newHashSet(newTasks)).size()});
                this.tasks.clear();
                this.tasks.addAll(newTasks);
                this.managementMayBeNecessary.signalAll();
            } else {
                log.info("Not active. Skipping storage sync.", new Object[0]);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to sync tasks from storage!", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.giant.unlock();
        }
    }
}

