/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.google.common.io.InputSupplier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.guice.annotations.Self;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.overlord.ZkWorker;
import io.druid.indexing.overlord.config.ForkingTaskRunnerConfig;
import io.druid.indexing.worker.config.WorkerConfig;
import io.druid.server.DruidNode;
import io.druid.tasklogs.TaskLogPusher;
import io.druid.tasklogs.TaskLogStreamer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ForkingTaskRunner
implements TaskRunner,
TaskLogStreamer {
    private static final EmittingLogger log = new EmittingLogger(ForkingTaskRunner.class);
    private static final String CHILD_PROPERTY_PREFIX = "druid.indexer.fork.property.";
    private static final Splitter whiteSpaceSplitter = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings();
    private final ForkingTaskRunnerConfig config;
    private final Properties props;
    private final TaskLogPusher taskLogPusher;
    private final DruidNode node;
    private final ListeningExecutorService exec;
    private final ObjectMapper jsonMapper;
    private final Map<String, ForkingTaskRunnerWorkItem> tasks = Maps.newHashMap();

    @Inject
    public ForkingTaskRunner(ForkingTaskRunnerConfig config, WorkerConfig workerConfig, Properties props, TaskLogPusher taskLogPusher, ObjectMapper jsonMapper, @Self DruidNode node) {
        this.config = config;
        this.props = props;
        this.taskLogPusher = taskLogPusher;
        this.jsonMapper = jsonMapper;
        this.node = node;
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(workerConfig.getCapacity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<TaskStatus> run(final Task task) {
        Map<String, ForkingTaskRunnerWorkItem> map = this.tasks;
        synchronized (map) {
            if (!this.tasks.containsKey(task.getId())) {
                this.tasks.put(task.getId(), new ForkingTaskRunnerWorkItem(task.getId(), this.exec.submit((Callable)new Callable<TaskStatus>(){

                    /*
                     * Exception decompiling
                     */
                    @Override
                    public TaskStatus call() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                })));
            }
            return this.tasks.get(task.getId()).getResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Map<String, ForkingTaskRunnerWorkItem> map = this.tasks;
        synchronized (map) {
            this.exec.shutdown();
            for (ForkingTaskRunnerWorkItem taskWorkItem : this.tasks.values()) {
                if (taskWorkItem.processHolder == null) continue;
                log.info("Destroying process: %s", new Object[]{taskWorkItem.processHolder.process});
                taskWorkItem.processHolder.process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(String taskid) {
        ForkingTaskRunnerWorkItem taskInfo;
        Map<String, ForkingTaskRunnerWorkItem> map = this.tasks;
        synchronized (map) {
            taskInfo = this.tasks.get(taskid);
            if (taskInfo == null) {
                log.info("Ignoring request to cancel unknown task: %s", new Object[]{taskid});
                return;
            }
            taskInfo.shutdown = true;
        }
        if (taskInfo.processHolder != null) {
            log.info("Killing process for task: %s", new Object[]{taskid});
            taskInfo.processHolder.process.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskRunnerWorkItem> getRunningTasks() {
        Map<String, ForkingTaskRunnerWorkItem> map = this.tasks;
        synchronized (map) {
            ArrayList ret = Lists.newArrayList();
            for (ForkingTaskRunnerWorkItem taskWorkItem : this.tasks.values()) {
                if (taskWorkItem.processHolder == null) continue;
                ret.add(taskWorkItem);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskRunnerWorkItem> getPendingTasks() {
        Map<String, ForkingTaskRunnerWorkItem> map = this.tasks;
        synchronized (map) {
            ArrayList ret = Lists.newArrayList();
            for (ForkingTaskRunnerWorkItem taskWorkItem : this.tasks.values()) {
                if (taskWorkItem.processHolder != null) continue;
                ret.add(taskWorkItem);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskRunnerWorkItem> getKnownTasks() {
        Map<String, ForkingTaskRunnerWorkItem> map = this.tasks;
        synchronized (map) {
            return Lists.newArrayList(this.tasks.values());
        }
    }

    @Override
    public Collection<ZkWorker> getWorkers() {
        return ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<InputSupplier<InputStream>> streamTaskLog(String taskid, final long offset) {
        ProcessHolder processHolder;
        Map<String, ForkingTaskRunnerWorkItem> map = this.tasks;
        synchronized (map) {
            ForkingTaskRunnerWorkItem taskWorkItem = this.tasks.get(taskid);
            if (taskWorkItem == null || taskWorkItem.processHolder == null) {
                return Optional.absent();
            }
            processHolder = taskWorkItem.processHolder;
        }
        return Optional.of((Object)new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                RandomAccessFile raf = new RandomAccessFile(processHolder.logFile, "r");
                long rafLength = raf.length();
                if (offset > 0L) {
                    raf.seek(offset);
                } else if (offset < 0L && offset < rafLength) {
                    raf.seek(Math.max(0L, rafLength + offset));
                }
                return Channels.newInputStream(raf.getChannel());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findUnusedPort() {
        Map<String, ForkingTaskRunnerWorkItem> map = this.tasks;
        synchronized (map) {
            int port = this.config.getStartPort();
            int maxPortSoFar = -1;
            for (ForkingTaskRunnerWorkItem taskWorkItem : this.tasks.values()) {
                if (taskWorkItem.processHolder == null) continue;
                if (taskWorkItem.processHolder.port > maxPortSoFar) {
                    maxPortSoFar = taskWorkItem.processHolder.port;
                }
                if (taskWorkItem.processHolder.port != port) continue;
                port = maxPortSoFar + 1;
            }
            return port;
        }
    }

    static /* synthetic */ ForkingTaskRunnerConfig access$000(ForkingTaskRunner x0) {
        return x0.config;
    }

    static /* synthetic */ Map access$100(ForkingTaskRunner x0) {
        return x0.tasks;
    }

    static /* synthetic */ EmittingLogger access$300() {
        return log;
    }

    static /* synthetic */ int access$500(ForkingTaskRunner x0) {
        return x0.findUnusedPort();
    }

    static /* synthetic */ DruidNode access$600(ForkingTaskRunner x0) {
        return x0.node;
    }

    static /* synthetic */ Splitter access$700() {
        return whiteSpaceSplitter;
    }

    static /* synthetic */ Properties access$800(ForkingTaskRunner x0) {
        return x0.props;
    }

    static /* synthetic */ ObjectMapper access$900(ForkingTaskRunner x0) {
        return x0.jsonMapper;
    }

    static /* synthetic */ TaskLogPusher access$1300(ForkingTaskRunner x0) {
        return x0.taskLogPusher;
    }

    private static class ProcessHolder {
        private final Process process;
        private final File logFile;
        private final int port;

        private ProcessHolder(Process process, File logFile, int port) {
            this.process = process;
            this.logFile = logFile;
            this.port = port;
        }

        private void registerWithCloser(Closer closer) {
            closer.register((Closeable)this.process.getInputStream());
            closer.register((Closeable)this.process.getOutputStream());
        }

        static /* synthetic */ void access$1100(ProcessHolder x0, Closer x1) {
            x0.registerWithCloser(x1);
        }
    }

    private static class ForkingTaskRunnerWorkItem
    extends TaskRunnerWorkItem {
        private volatile boolean shutdown = false;
        private volatile ProcessHolder processHolder = null;

        private ForkingTaskRunnerWorkItem(String taskId, ListenableFuture<TaskStatus> statusFuture) {
            super(taskId, statusFuture);
        }

        static /* synthetic */ boolean access$200(ForkingTaskRunnerWorkItem x0) {
            return x0.shutdown;
        }

        static /* synthetic */ ProcessHolder access$402(ForkingTaskRunnerWorkItem x0, ProcessHolder x1) {
            x0.processHolder = x1;
            return x0.processHolder;
        }
    }
}

