/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.common.RetryUtils;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import com.mysql.jdbc.exceptions.MySQLTransientException;
import io.druid.db.DbConnector;
import io.druid.db.DbTablesConfig;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.config.TaskStorageConfig;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskExistsException;
import io.druid.indexing.overlord.TaskStorage;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.StatementException;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class DbTaskStorage
implements TaskStorage {
    private final ObjectMapper jsonMapper;
    private final DbConnector dbConnector;
    private final DbTablesConfig dbTables;
    private final IDBI dbi;
    private final TaskStorageConfig config;
    private static final EmittingLogger log = new EmittingLogger(DbTaskStorage.class);

    @Inject
    public DbTaskStorage(ObjectMapper jsonMapper, DbConnector dbConnector, DbTablesConfig dbTables, IDBI dbi, TaskStorageConfig config) {
        this.jsonMapper = jsonMapper;
        this.dbConnector = dbConnector;
        this.dbTables = dbTables;
        this.dbi = dbi;
        this.config = config;
    }

    @LifecycleStart
    public void start() {
        this.dbConnector.createTaskTables();
    }

    @LifecycleStop
    public void stop() {
    }

    @Override
    public void insert(final Task task, final TaskStatus status) throws TaskExistsException {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkArgument((boolean)task.getId().equals(status.getId()), (String)"Task/Status ID mismatch[%s/%s]", (Object[])new Object[]{task.getId(), status.getId()});
        log.info("Inserting task %s with status: %s", new Object[]{task.getId(), status});
        try {
            this.retryingHandle(new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %s (id, created_date, datasource, payload, active, status_payload) VALUES (:id, :created_date, :datasource, :payload, :active, :status_payload)", DbTaskStorage.this.dbTables.getTasksTable())).bind("id", task.getId())).bind("created_date", new DateTime().toString())).bind("datasource", task.getDataSource())).bind("payload", DbTaskStorage.this.jsonMapper.writeValueAsBytes((Object)task))).bind("active", status.isRunnable() ? 1 : 0)).bind("status_payload", DbTaskStorage.this.jsonMapper.writeValueAsBytes((Object)status))).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            boolean isStatementException;
            boolean bl = isStatementException = e instanceof StatementException || e instanceof CallbackFailedException && e.getCause() instanceof StatementException;
            if (isStatementException && this.getTask(task.getId()).isPresent()) {
                throw new TaskExistsException(task.getId(), e);
            }
            throw e;
        }
    }

    @Override
    public void setStatus(final TaskStatus status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        log.info("Updating task %s to status: %s", new Object[]{status.getId(), status});
        int updated = this.retryingHandle(new HandleCallback<Integer>(){

            public Integer withHandle(Handle handle) throws Exception {
                return ((Update)((Update)((Update)handle.createStatement(String.format("UPDATE %s SET active = :active, status_payload = :status_payload WHERE id = :id AND active = 1", DbTaskStorage.this.dbTables.getTasksTable())).bind("id", status.getId())).bind("active", status.isRunnable() ? 1 : 0)).bind("status_payload", DbTaskStorage.this.jsonMapper.writeValueAsBytes((Object)status))).execute();
            }
        });
        if (updated != 1) {
            throw new IllegalStateException(String.format("Active task not found: %s", status.getId()));
        }
    }

    @Override
    public Optional<Task> getTask(final String taskid) {
        return this.retryingHandle(new HandleCallback<Optional<Task>>(){

            public Optional<Task> withHandle(Handle handle) throws Exception {
                List dbTasks = ((Query)handle.createQuery(String.format("SELECT payload FROM %s WHERE id = :id", DbTaskStorage.this.dbTables.getTasksTable())).bind("id", taskid)).list();
                if (dbTasks.size() == 0) {
                    return Optional.absent();
                }
                Map dbStatus = (Map)Iterables.getOnlyElement((Iterable)dbTasks);
                return Optional.of((Object)DbTaskStorage.this.jsonMapper.readValue((byte[])dbStatus.get("payload"), Task.class));
            }
        });
    }

    @Override
    public Optional<TaskStatus> getStatus(final String taskid) {
        return this.retryingHandle(new HandleCallback<Optional<TaskStatus>>(){

            public Optional<TaskStatus> withHandle(Handle handle) throws Exception {
                List dbStatuses = ((Query)handle.createQuery(String.format("SELECT status_payload FROM %s WHERE id = :id", DbTaskStorage.this.dbTables.getTasksTable())).bind("id", taskid)).list();
                if (dbStatuses.size() == 0) {
                    return Optional.absent();
                }
                Map dbStatus = (Map)Iterables.getOnlyElement((Iterable)dbStatuses);
                return Optional.of((Object)DbTaskStorage.this.jsonMapper.readValue((byte[])dbStatus.get("status_payload"), TaskStatus.class));
            }
        });
    }

    @Override
    public List<Task> getActiveTasks() {
        return this.retryingHandle(new HandleCallback<List<Task>>(){

            public List<Task> withHandle(Handle handle) throws Exception {
                List dbTasks = handle.createQuery(String.format("SELECT id, payload, status_payload FROM %s WHERE active = 1 ORDER BY created_date", DbTaskStorage.this.dbTables.getTasksTable())).list();
                ImmutableList.Builder tasks = ImmutableList.builder();
                for (Map row : dbTasks) {
                    String id = row.get("id").toString();
                    try {
                        Task task = (Task)DbTaskStorage.this.jsonMapper.readValue((byte[])row.get("payload"), Task.class);
                        TaskStatus status = (TaskStatus)DbTaskStorage.this.jsonMapper.readValue((byte[])row.get("status_payload"), TaskStatus.class);
                        if (!status.isRunnable()) continue;
                        tasks.add((Object)task);
                    }
                    catch (Exception e) {
                        log.makeAlert((Throwable)e, "Failed to parse task payload", new Object[0]).addData("task", (Object)id).emit();
                    }
                }
                return tasks.build();
            }
        });
    }

    @Override
    public List<TaskStatus> getRecentlyFinishedTaskStatuses() {
        final DateTime recent = new DateTime().minus((ReadableDuration)this.config.getRecentlyFinishedThreshold());
        return this.retryingHandle(new HandleCallback<List<TaskStatus>>(){

            public List<TaskStatus> withHandle(Handle handle) throws Exception {
                List dbTasks = ((Query)handle.createQuery(String.format("SELECT id, status_payload FROM %s WHERE active = 0 AND created_date >= :recent ORDER BY created_date DESC", DbTaskStorage.this.dbTables.getTasksTable())).bind("recent", recent.toString())).list();
                ImmutableList.Builder statuses = ImmutableList.builder();
                for (Map row : dbTasks) {
                    String id = row.get("id").toString();
                    try {
                        TaskStatus status = (TaskStatus)DbTaskStorage.this.jsonMapper.readValue((byte[])row.get("status_payload"), TaskStatus.class);
                        if (!status.isComplete()) continue;
                        statuses.add((Object)status);
                    }
                    catch (Exception e) {
                        log.makeAlert((Throwable)e, "Failed to parse status payload", new Object[0]).addData("task", (Object)id).emit();
                    }
                }
                return statuses.build();
            }
        });
    }

    @Override
    public void addLock(final String taskid, final TaskLock taskLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
        log.info("Adding lock on interval[%s] version[%s] for task: %s", new Object[]{taskLock.getInterval(), taskLock.getVersion(), taskid});
        this.retryingHandle(new HandleCallback<Integer>(){

            public Integer withHandle(Handle handle) throws Exception {
                return ((Update)((Update)handle.createStatement(String.format("INSERT INTO %s (task_id, lock_payload) VALUES (:task_id, :lock_payload)", DbTaskStorage.this.dbTables.getTaskLockTable())).bind("task_id", taskid)).bind("lock_payload", DbTaskStorage.this.jsonMapper.writeValueAsBytes((Object)taskLock))).execute();
            }
        });
    }

    @Override
    public void removeLock(String taskid, TaskLock taskLockToRemove) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLockToRemove, (Object)"taskLockToRemove");
        Map<Long, TaskLock> taskLocks = this.getLocksWithIds(taskid);
        for (Map.Entry<Long, TaskLock> taskLockWithId : taskLocks.entrySet()) {
            final long id = taskLockWithId.getKey();
            TaskLock taskLock = taskLockWithId.getValue();
            if (!taskLock.equals(taskLockToRemove)) continue;
            log.info("Deleting TaskLock with id[%d]: %s", new Object[]{id, taskLock});
            this.retryingHandle(new HandleCallback<Integer>(){

                public Integer withHandle(Handle handle) throws Exception {
                    return ((Update)handle.createStatement(String.format("DELETE FROM %s WHERE id = :id", DbTaskStorage.this.dbTables.getTaskLockTable())).bind("id", id)).execute();
                }
            });
        }
    }

    @Override
    public List<TaskLock> getLocks(String taskid) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.getLocksWithIds(taskid).entrySet(), (Function)new Function<Map.Entry<Long, TaskLock>, TaskLock>(){

            public TaskLock apply(Map.Entry<Long, TaskLock> e) {
                return e.getValue();
            }
        }));
    }

    @Override
    public <T> void addAuditLog(final Task task, final TaskAction<T> taskAction) {
        Preconditions.checkNotNull(taskAction, (Object)"taskAction");
        log.info("Logging action for task[%s]: %s", new Object[]{task.getId(), taskAction});
        this.retryingHandle(new HandleCallback<Integer>(){

            public Integer withHandle(Handle handle) throws Exception {
                return ((Update)((Update)handle.createStatement(String.format("INSERT INTO %s (task_id, log_payload) VALUES (:task_id, :log_payload)", DbTaskStorage.this.dbTables.getTaskLogTable())).bind("task_id", task.getId())).bind("log_payload", DbTaskStorage.this.jsonMapper.writeValueAsBytes((Object)taskAction))).execute();
            }
        });
    }

    @Override
    public List<TaskAction> getAuditLogs(final String taskid) {
        return this.retryingHandle(new HandleCallback<List<TaskAction>>(){

            public List<TaskAction> withHandle(Handle handle) throws Exception {
                List dbTaskLogs = ((Query)handle.createQuery(String.format("SELECT log_payload FROM %s WHERE task_id = :task_id", DbTaskStorage.this.dbTables.getTaskLogTable())).bind("task_id", taskid)).list();
                ArrayList retList = Lists.newArrayList();
                for (Map dbTaskLog : dbTaskLogs) {
                    try {
                        retList.add(DbTaskStorage.this.jsonMapper.readValue((byte[])dbTaskLog.get("log_payload"), TaskAction.class));
                    }
                    catch (Exception e) {
                        log.makeAlert((Throwable)e, "Failed to deserialize TaskLog", new Object[0]).addData("task", (Object)taskid).addData("logPayload", (Object)dbTaskLog).emit();
                    }
                }
                return retList;
            }
        });
    }

    private Map<Long, TaskLock> getLocksWithIds(final String taskid) {
        return this.retryingHandle(new HandleCallback<Map<Long, TaskLock>>(){

            public Map<Long, TaskLock> withHandle(Handle handle) throws Exception {
                List dbTaskLocks = ((Query)handle.createQuery(String.format("SELECT id, lock_payload FROM %s WHERE task_id = :task_id", DbTaskStorage.this.dbTables.getTaskLockTable())).bind("task_id", taskid)).list();
                HashMap retMap = Maps.newHashMap();
                for (Map row : dbTaskLocks) {
                    try {
                        retMap.put((Long)row.get("id"), DbTaskStorage.this.jsonMapper.readValue((byte[])row.get("lock_payload"), TaskLock.class));
                    }
                    catch (Exception e) {
                        log.makeAlert((Throwable)e, "Failed to deserialize TaskLock", new Object[0]).addData("task", (Object)taskid).addData("lockPayload", (Object)row).emit();
                    }
                }
                return retMap;
            }
        });
    }

    private <T> T retryingHandle(final HandleCallback<T> callback) {
        Callable call = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return DbTaskStorage.this.dbi.withHandle(callback);
            }
        };
        Predicate<Throwable> shouldRetry = new Predicate<Throwable>(){

            public boolean apply(Throwable e) {
                return DbTaskStorage.shouldRetryException(e);
            }
        };
        int maxTries = 10;
        try {
            return (T)RetryUtils.retry((Callable)call, (Predicate)shouldRetry, (int)10);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static boolean shouldRetryException(Throwable e) {
        return e != null && (e instanceof SQLTransientException || e instanceof MySQLTransientException || e instanceof SQLRecoverableException || e instanceof UnableToObtainConnectionException || e instanceof SQLException && ((SQLException)e).getErrorCode() == 1317 || e instanceof SQLException && DbTaskStorage.shouldRetryException(e.getCause()) || e instanceof DBIException && DbTaskStorage.shouldRetryException(e.getCause()));
    }
}

