/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.tasklogs;

import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.indexing.common.config.FileTaskLogsConfig;
import io.druid.tasklogs.TaskLogs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileTaskLogs
implements TaskLogs {
    private static final Logger log = new Logger(FileTaskLogs.class);
    private final FileTaskLogsConfig config;

    @Inject
    public FileTaskLogs(FileTaskLogsConfig config) {
        this.config = config;
    }

    public void pushTaskLog(String taskid, File file) throws IOException {
        if (!this.config.getDirectory().exists()) {
            this.config.getDirectory().mkdir();
        }
        File outputFile = this.fileForTask(taskid);
        Files.copy((File)file, (File)outputFile);
        log.info("Wrote task log to: %s", new Object[]{outputFile});
    }

    public Optional<InputSupplier<InputStream>> streamTaskLog(String taskid, final long offset) throws IOException {
        final File file = this.fileForTask(taskid);
        if (file.exists()) {
            return Optional.of((Object)new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    FileInputStream inputStream = new FileInputStream(file);
                    ByteStreams.skipFully((InputStream)inputStream, (long)offset);
                    return inputStream;
                }
            });
        }
        return Optional.absent();
    }

    private File fileForTask(String taskid) {
        return new File(this.config.getDirectory(), String.format("%s.log", taskid));
    }
}

