/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.logger.Logger;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.SegmentInsertAction;
import io.druid.indexing.common.actions.SegmentListUsedAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractFixedIntervalTask;
import io.druid.indexing.common.task.Task;
import io.druid.segment.IndexIO;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class VersionConverterTask
extends AbstractFixedIntervalTask {
    private static final String TYPE = "version_converter";
    private static final Integer CURR_VERSION_INTEGER = 9;
    private static final Logger log = new Logger(VersionConverterTask.class);
    @JsonIgnore
    private final DataSegment segment;

    public static VersionConverterTask create(String dataSource, Interval interval) {
        String id = VersionConverterTask.makeId(dataSource, interval);
        return new VersionConverterTask(id, id, dataSource, interval, null);
    }

    public static VersionConverterTask create(DataSegment segment) {
        Interval interval = segment.getInterval();
        String dataSource = segment.getDataSource();
        String id = VersionConverterTask.makeId(dataSource, interval);
        return new VersionConverterTask(id, id, dataSource, interval, segment);
    }

    private static String makeId(String dataSource, Interval interval) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)interval, (Object)"interval");
        return VersionConverterTask.joinId(TYPE, dataSource, interval.getStart(), interval.getEnd(), new DateTime());
    }

    @JsonCreator
    private static VersionConverterTask createFromJson(@JsonProperty(value="id") String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="segment") DataSegment segment) {
        if (id == null) {
            if (segment == null) {
                return VersionConverterTask.create(dataSource, interval);
            }
            return VersionConverterTask.create(segment);
        }
        return new VersionConverterTask(id, groupId, dataSource, interval, segment);
    }

    private VersionConverterTask(String id, String groupId, String dataSource, Interval interval, DataSegment segment) {
        super(id, groupId, dataSource, interval);
        this.segment = segment;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @JsonProperty
    public DataSegment getSegment() {
        return this.segment;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        if (this.segment == null) {
            List<DataSegment> segments = toolbox.getTaskActionClient().submit(new SegmentListUsedAction(this.getDataSource(), this.getInterval()));
            FunctionalIterable tasks = FunctionalIterable.create(segments).keep((Function)new Function<DataSegment, Task>(){

                public Task apply(DataSegment segment) {
                    Integer segmentVersion = segment.getBinaryVersion();
                    if (!CURR_VERSION_INTEGER.equals(segmentVersion)) {
                        return new SubTask(VersionConverterTask.this.getGroupId(), segment);
                    }
                    log.info("Skipping[%s], already version[%s]", new Object[]{segment.getIdentifier(), segmentVersion});
                    return null;
                }
            });
            for (Task subTask : tasks) {
                TaskStatus status = subTask.run(toolbox);
                if (status.isSuccess()) continue;
                return status;
            }
        } else {
            log.info("I'm in a subless mood.", new Object[0]);
            VersionConverterTask.convertSegment(toolbox, this.segment);
        }
        return this.success();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionConverterTask that = (VersionConverterTask)o;
        if (this.segment != null ? !this.segment.equals((Object)that.segment) : that.segment != null) {
            return false;
        }
        return super.equals(o);
    }

    private static void convertSegment(TaskToolbox toolbox, DataSegment segment) throws SegmentLoadingException, IOException {
        File outLocation;
        log.info("Converting segment[%s]", new Object[]{segment});
        TaskActionClient actionClient = toolbox.getTaskActionClient();
        List<DataSegment> currentSegments = actionClient.submit(new SegmentListUsedAction(segment.getDataSource(), segment.getInterval()));
        for (DataSegment currentSegment : currentSegments) {
            String version = currentSegment.getVersion();
            Integer binaryVersion = currentSegment.getBinaryVersion();
            if (!version.startsWith(segment.getVersion()) || !CURR_VERSION_INTEGER.equals(binaryVersion)) continue;
            log.info("Skipping already updated segment[%s].", new Object[]{segment});
            return;
        }
        Map<DataSegment, File> localSegments = toolbox.fetchSegments(Arrays.asList(segment));
        File location = localSegments.get(segment);
        if (IndexIO.convertSegment((File)location, (File)(outLocation = new File(location, "v9_out")))) {
            int outVersion = IndexIO.getVersionFromDir((File)outLocation);
            DataSegment updatedSegment = segment.withVersion(String.format("%s_v%s", segment.getVersion(), outVersion));
            updatedSegment = toolbox.getSegmentPusher().push(outLocation, updatedSegment);
            actionClient.submit(new SegmentInsertAction(Sets.newHashSet((Object[])new DataSegment[]{updatedSegment})).withAllowOlderVersions(true));
        } else {
            log.info("Conversion failed.", new Object[0]);
        }
    }

    public static class SubTask
    extends AbstractFixedIntervalTask {
        @JsonIgnore
        private final DataSegment segment;

        @JsonCreator
        public SubTask(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="segment") DataSegment segment) {
            super(SubTask.joinId(groupId, "sub", segment.getInterval().getStart(), segment.getInterval().getEnd(), segment.getShardSpec().getPartitionNum()), groupId, segment.getDataSource(), segment.getInterval());
            this.segment = segment;
        }

        @JsonProperty
        public DataSegment getSegment() {
            return this.segment;
        }

        @Override
        public String getType() {
            return "version_converter_sub";
        }

        @Override
        public TaskStatus run(TaskToolbox toolbox) throws Exception {
            log.info("Subs are good!  Italian BMT and Meatball are probably my favorite.", new Object[0]);
            VersionConverterTask.convertSegment(toolbox, this.segment);
            return this.success();
        }
    }
}

