/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import com.metamx.common.exception.FormattedException;
import com.metamx.emitter.EmittingLogger;
import com.metamx.metrics.Monitor;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.LockAcquireAction;
import io.druid.indexing.common.actions.LockReleaseAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractTask;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.common.task.TaskResource;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QueryToolChest;
import io.druid.segment.IndexGranularity;
import io.druid.segment.realtime.FireDepartment;
import io.druid.segment.realtime.FireDepartmentConfig;
import io.druid.segment.realtime.RealtimeMetricsMonitor;
import io.druid.segment.realtime.Schema;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.RealtimePlumberSchool;
import io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import io.druid.segment.realtime.plumber.Sink;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class RealtimeIndexTask
extends AbstractTask {
    private static final EmittingLogger log = new EmittingLogger(RealtimeIndexTask.class);
    @JsonIgnore
    private final Schema schema;
    @JsonIgnore
    private final FirehoseFactory firehoseFactory;
    @JsonIgnore
    private final FireDepartmentConfig fireDepartmentConfig;
    @JsonIgnore
    private final Period windowPeriod;
    @JsonIgnore
    private final int maxPendingPersists;
    @JsonIgnore
    private final IndexGranularity segmentGranularity;
    @JsonIgnore
    private final RejectionPolicyFactory rejectionPolicyFactory;
    @JsonIgnore
    private volatile Plumber plumber = null;
    @JsonIgnore
    private volatile QueryRunnerFactoryConglomerate queryRunnerFactoryConglomerate = null;

    private static String makeTaskId(String dataSource, int partitionNum, String version) {
        return String.format("index_realtime_%s_%d_%s", dataSource, partitionNum, version);
    }

    @JsonCreator
    public RealtimeIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="schema") Schema schema, @JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="fireDepartmentConfig") FireDepartmentConfig fireDepartmentConfig, @JsonProperty(value="windowPeriod") Period windowPeriod, @JsonProperty(value="maxPendingPersists") int maxPendingPersists, @JsonProperty(value="segmentGranularity") IndexGranularity segmentGranularity, @JsonProperty(value="rejectionPolicy") RejectionPolicyFactory rejectionPolicyFactory) {
        super(id == null ? RealtimeIndexTask.makeTaskId(schema.getDataSource(), schema.getShardSpec().getPartitionNum(), new DateTime().toString()) : id, String.format("index_realtime_%s", schema.getDataSource()), taskResource == null ? new TaskResource(RealtimeIndexTask.makeTaskId(schema.getDataSource(), schema.getShardSpec().getPartitionNum(), new DateTime().toString()), 1) : taskResource, schema.getDataSource());
        this.schema = schema;
        this.firehoseFactory = firehoseFactory;
        this.fireDepartmentConfig = fireDepartmentConfig;
        this.windowPeriod = windowPeriod;
        this.maxPendingPersists = maxPendingPersists == 0 ? 2 : maxPendingPersists;
        this.segmentGranularity = segmentGranularity;
        this.rejectionPolicyFactory = rejectionPolicyFactory;
    }

    @Override
    public String getType() {
        return "index_realtime";
    }

    @Override
    public String getNodeType() {
        return "realtime";
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        if (this.plumber != null) {
            QueryRunnerFactory factory = this.queryRunnerFactoryConglomerate.findFactory(query);
            QueryToolChest toolChest = factory.getToolchest();
            return new FinalizeResultsQueryRunner(this.plumber.getQueryRunner(query), toolChest);
        }
        return null;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus run(final TaskToolbox toolbox) throws Exception {
        if (this.plumber != null) {
            throw new IllegalStateException("WTF?!? run with non-null plumber??!");
        }
        for (TaskLock taskLock : this.getTaskLocks(toolbox)) {
            toolbox.getTaskActionClient().submit(new LockReleaseAction(taskLock.getInterval()));
        }
        boolean normalExit = true;
        Period intermediatePersistPeriod = this.fireDepartmentConfig.getIntermediatePersistPeriod();
        Firehose firehose = this.firehoseFactory.connect();
        RealtimePlumberSchool realtimePlumberSchool = new RealtimePlumberSchool(this.windowPeriod, new File(toolbox.getTaskWorkDir(), "persist"), this.segmentGranularity);
        realtimePlumberSchool.setDefaultMaxPendingPersists(this.maxPendingPersists);
        TaskActionSegmentPublisher segmentPublisher = new TaskActionSegmentPublisher(this, toolbox);
        DataSegmentAnnouncer lockingSegmentAnnouncer = new DataSegmentAnnouncer(){

            public void announceSegment(DataSegment segment) throws IOException {
                toolbox.getTaskActionClient().submit(new LockAcquireAction(segment.getInterval()));
                toolbox.getSegmentAnnouncer().announceSegment(segment);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unannounceSegment(DataSegment segment) throws IOException {
                try {
                    toolbox.getSegmentAnnouncer().unannounceSegment(segment);
                }
                finally {
                    toolbox.getTaskActionClient().submit(new LockReleaseAction(segment.getInterval()));
                }
            }

            public void announceSegments(Iterable<DataSegment> segments) throws IOException {
                for (DataSegment segment : segments) {
                    toolbox.getTaskActionClient().submit(new LockAcquireAction(segment.getInterval()));
                }
                toolbox.getSegmentAnnouncer().announceSegments(segments);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unannounceSegments(Iterable<DataSegment> segments) throws IOException {
                try {
                    toolbox.getSegmentAnnouncer().unannounceSegments(segments);
                }
                finally {
                    for (DataSegment segment : segments) {
                        toolbox.getTaskActionClient().submit(new LockReleaseAction(segment.getInterval()));
                    }
                }
            }
        };
        VersioningPolicy versioningPolicy = new VersioningPolicy(){

            public String getVersion(Interval interval) {
                try {
                    TaskLock myLock = toolbox.getTaskActionClient().submit(new LockAcquireAction(interval));
                    return myLock.getVersion();
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
        realtimePlumberSchool.setDataSegmentPusher(toolbox.getSegmentPusher());
        realtimePlumberSchool.setConglomerate(toolbox.getQueryRunnerFactoryConglomerate());
        realtimePlumberSchool.setQueryExecutorService(toolbox.getQueryExecutorService());
        realtimePlumberSchool.setVersioningPolicy(versioningPolicy);
        realtimePlumberSchool.setSegmentAnnouncer(lockingSegmentAnnouncer);
        realtimePlumberSchool.setSegmentPublisher((SegmentPublisher)segmentPublisher);
        realtimePlumberSchool.setServerView(toolbox.getNewSegmentServerView());
        realtimePlumberSchool.setEmitter(toolbox.getEmitter());
        if (this.rejectionPolicyFactory != null) {
            realtimePlumberSchool.setRejectionPolicyFactory(this.rejectionPolicyFactory);
        }
        FireDepartment fireDepartment = new FireDepartment(this.schema, this.fireDepartmentConfig, null, null);
        RealtimeMetricsMonitor metricsMonitor = new RealtimeMetricsMonitor((List)ImmutableList.of((Object)fireDepartment));
        this.queryRunnerFactoryConglomerate = toolbox.getQueryRunnerFactoryConglomerate();
        this.plumber = realtimePlumberSchool.findPlumber(this.schema, fireDepartment.getMetrics());
        try {
            this.plumber.startJob();
            toolbox.getMonitorScheduler().addMonitor((Monitor)metricsMonitor);
            long nextFlush = new DateTime().plus((ReadablePeriod)intermediatePersistPeriod).getMillis();
            while (firehose.hasMore()) {
                try {
                    InputRow inputRow = firehose.nextRow();
                    if (inputRow == null) continue;
                    Sink sink = this.plumber.getSink(inputRow.getTimestampFromEpoch());
                    if (sink == null) {
                        fireDepartment.getMetrics().incrementThrownAway();
                        log.debug("Throwing away event[%s]", new Object[]{inputRow});
                        if (System.currentTimeMillis() <= nextFlush) continue;
                        this.plumber.persist(firehose.commit());
                        nextFlush = new DateTime().plus((ReadablePeriod)intermediatePersistPeriod).getMillis();
                        continue;
                    }
                    if (sink.isEmpty()) {
                        log.info("Task %s: New sink: %s", new Object[]{this.getId(), sink});
                    }
                    int currCount = sink.add(inputRow);
                    fireDepartment.getMetrics().incrementProcessed();
                    if (currCount < this.fireDepartmentConfig.getMaxRowsInMemory() && System.currentTimeMillis() <= nextFlush) continue;
                    this.plumber.persist(firehose.commit());
                    nextFlush = new DateTime().plus((ReadablePeriod)intermediatePersistPeriod).getMillis();
                }
                catch (FormattedException e) {
                    log.warn((Throwable)e, "unparseable line", new Object[0]);
                    fireDepartment.getMetrics().incrementUnparseable();
                }
            }
        }
        catch (Throwable e) {
            normalExit = false;
            log.makeAlert(e, "Exception aborted realtime processing[%s]", new Object[]{this.schema.getDataSource()}).emit();
            throw e;
        }
        finally {
            if (normalExit) {
                try {
                    this.plumber.persist(firehose.commit());
                    this.plumber.finishJob();
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to finish realtime task", new Object[0]).emit();
                }
                finally {
                    Closeables.closeQuietly((Closeable)firehose);
                    toolbox.getMonitorScheduler().removeMonitor((Monitor)metricsMonitor);
                }
            }
        }
        return TaskStatus.success(this.getId());
    }

    @JsonProperty
    public Schema getSchema() {
        return this.schema;
    }

    @JsonProperty(value="firehose")
    public FirehoseFactory getFirehoseFactory() {
        return this.firehoseFactory;
    }

    @JsonProperty
    public FireDepartmentConfig getFireDepartmentConfig() {
        return this.fireDepartmentConfig;
    }

    @JsonProperty
    public Period getWindowPeriod() {
        return this.windowPeriod;
    }

    @JsonProperty
    public IndexGranularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @JsonProperty(value="rejectionPolicy")
    public RejectionPolicyFactory getRejectionPolicyFactory() {
        return this.rejectionPolicyFactory;
    }

    public static class TaskActionSegmentPublisher
    implements SegmentPublisher {
        final Task task;
        final TaskToolbox taskToolbox;

        public TaskActionSegmentPublisher(Task task, TaskToolbox taskToolbox) {
            this.task = task;
            this.taskToolbox = taskToolbox;
        }

        public void publishSegment(DataSegment segment) throws IOException {
            this.taskToolbox.pushSegments((Iterable<DataSegment>)ImmutableList.of((Object)segment));
        }
    }
}

