/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.metamx.common.ISE;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.SegmentListUsedAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractFixedIntervalTask;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class MergeTaskBase
extends AbstractFixedIntervalTask {
    @JsonIgnore
    private final List<DataSegment> segments;
    private static final EmittingLogger log = new EmittingLogger(MergeTaskBase.class);

    protected MergeTaskBase(String id, final String dataSource, List<DataSegment> segments) {
        super(id != null ? id : String.format("merge_%s_%s", MergeTaskBase.computeProcessingID(dataSource, segments), new DateTime().toString()), dataSource, MergeTaskBase.computeMergedInterval(segments));
        Preconditions.checkArgument((segments.size() > 0 ? 1 : 0) != 0, (Object)"segments nonempty");
        Preconditions.checkArgument((Iterables.size((Iterable)Iterables.filter(segments, (Predicate)new Predicate<DataSegment>(){

            public boolean apply(@Nullable DataSegment segment) {
                return segment == null || !segment.getDataSource().equalsIgnoreCase(dataSource);
            }
        })) == 0 ? 1 : 0) != 0, (Object)"segments in the wrong datasource");
        Preconditions.checkArgument((Iterables.size((Iterable)Iterables.filter(segments, (Predicate)new Predicate<DataSegment>(){

            public boolean apply(@Nullable DataSegment segment) {
                return segment == null || !(segment.getShardSpec() instanceof NoneShardSpec);
            }
        })) == 0 ? 1 : 0) != 0, (Object)"segments without NoneShardSpec");
        this.segments = segments;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        TaskLock myLock = (TaskLock)Iterables.getOnlyElement(this.getTaskLocks(toolbox));
        ServiceEmitter emitter = toolbox.getEmitter();
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        DataSegment mergedSegment = MergeTaskBase.computeMergedSegment(this.getDataSource(), myLock.getVersion(), this.segments);
        File taskDir = toolbox.getTaskWorkDir();
        try {
            long startTime = System.currentTimeMillis();
            log.info("Starting merge of id[%s], segments: %s", new Object[]{this.getId(), Lists.transform(this.segments, (Function)new Function<DataSegment, String>(){

                public String apply(@Nullable DataSegment input) {
                    return input.getIdentifier();
                }
            })});
            Map<DataSegment, File> gettedSegments = toolbox.fetchSegments(this.segments);
            File fileToUpload = this.merge(gettedSegments, new File(taskDir, "merged"));
            emitter.emit(builder.build("merger/numMerged", (Number)this.segments.size()));
            emitter.emit(builder.build("merger/mergeTime", (Number)(System.currentTimeMillis() - startTime)));
            log.info("[%s] : Merged %d segments in %,d millis", new Object[]{mergedSegment.getDataSource(), this.segments.size(), System.currentTimeMillis() - startTime});
            long uploadStart = System.currentTimeMillis();
            DataSegment uploadedSegment = toolbox.getSegmentPusher().push(fileToUpload, mergedSegment);
            emitter.emit(builder.build("merger/uploadTime", (Number)(System.currentTimeMillis() - uploadStart)));
            emitter.emit(builder.build("merger/mergeSize", (Number)uploadedSegment.getSize()));
            toolbox.pushSegments((Iterable<DataSegment>)ImmutableList.of((Object)uploadedSegment));
            return TaskStatus.success(this.getId());
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "Exception merging[%s]", new Object[]{mergedSegment.getDataSource()}).addData("interval", (Object)mergedSegment.getInterval()).emit();
            return TaskStatus.failure(this.getId());
        }
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        ImmutableSet requested;
        if (!super.isReady(taskActionClient)) {
            return false;
        }
        Function<DataSegment, String> toIdentifier = new Function<DataSegment, String>(){

            public String apply(DataSegment dataSegment) {
                return dataSegment.getIdentifier();
            }
        };
        ImmutableSet current = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)taskActionClient.submit(new SegmentListUsedAction(this.getDataSource(), this.getInterval())), (Function)toIdentifier));
        Sets.SetView missingFromRequested = Sets.difference((Set)current, (Set)(requested = ImmutableSet.copyOf((Iterable)Iterables.transform(this.segments, (Function)toIdentifier))));
        if (!missingFromRequested.isEmpty()) {
            throw new ISE("Merge is invalid: current segment(s) are not in the requested set: %s", new Object[]{Joiner.on((String)", ").join((Iterable)missingFromRequested)});
        }
        Sets.SetView missingFromCurrent = Sets.difference((Set)requested, (Set)current);
        if (!missingFromCurrent.isEmpty()) {
            throw new ISE("Merge is invalid: requested segment(s) are not in the current set: %s", new Object[]{Joiner.on((String)", ").join((Iterable)missingFromCurrent)});
        }
        return true;
    }

    protected abstract File merge(Map<DataSegment, File> var1, File var2) throws Exception;

    @JsonProperty
    public List<DataSegment> getSegments() {
        return this.segments;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("dataSource", (Object)this.getDataSource()).add("interval", (Object)this.getInterval()).add("segments", this.segments).toString();
    }

    private static String computeProcessingID(String dataSource, List<DataSegment> segments) {
        String segmentIDs = Joiner.on((String)"_").join(Iterables.transform((Iterable)Ordering.natural().sortedCopy(segments), (Function)new Function<DataSegment, String>(){

            public String apply(DataSegment x) {
                return String.format("%s_%s_%s_%s", x.getInterval().getStart(), x.getInterval().getEnd(), x.getVersion(), x.getShardSpec().getPartitionNum());
            }
        }));
        return String.format("%s_%s", dataSource, Hashing.sha1().hashString((CharSequence)segmentIDs, Charsets.UTF_8).toString().toLowerCase());
    }

    private static Interval computeMergedInterval(List<DataSegment> segments) {
        Preconditions.checkArgument((segments.size() > 0 ? 1 : 0) != 0, (Object)"segments.size() > 0");
        DateTime start = null;
        DateTime end = null;
        for (DataSegment segment : segments) {
            if (start == null || segment.getInterval().getStart().isBefore((ReadableInstant)start)) {
                start = segment.getInterval().getStart();
            }
            if (end != null && !segment.getInterval().getEnd().isAfter((ReadableInstant)end)) continue;
            end = segment.getInterval().getEnd();
        }
        return new Interval(start, end);
    }

    private static DataSegment computeMergedSegment(String dataSource, String version, List<DataSegment> segments) {
        Interval mergedInterval = MergeTaskBase.computeMergedInterval(segments);
        TreeSet mergedDimensions = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        TreeSet mergedMetrics = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (DataSegment segment : segments) {
            mergedDimensions.addAll(segment.getDimensions());
            mergedMetrics.addAll(segment.getMetrics());
        }
        return DataSegment.builder().dataSource(dataSource).interval(mergedInterval).version(version).binaryVersion(Integer.valueOf(9)).shardSpec((ShardSpec)new NoneShardSpec()).dimensions((List)Lists.newArrayList((Iterable)mergedDimensions)).metrics((List)Lists.newArrayList((Iterable)mergedMetrics)).build();
    }
}

