/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Ints;
import com.metamx.common.ISE;
import com.metamx.common.guava.Comparators;
import com.metamx.common.logger.Logger;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.SpatialDimensionSchema;
import io.druid.granularity.QueryGranularity;
import io.druid.indexer.granularity.GranularitySpec;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.index.YeOldePlumberSchool;
import io.druid.indexing.common.task.AbstractFixedIntervalTask;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.Schema;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.Sink;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.SingleDimensionShardSpec;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexTask
extends AbstractFixedIntervalTask {
    private static final Logger log = new Logger(IndexTask.class);
    @JsonIgnore
    private final GranularitySpec granularitySpec;
    @JsonProperty
    private final List<SpatialDimensionSchema> spatialDimensions;
    @JsonIgnore
    private final AggregatorFactory[] aggregators;
    @JsonIgnore
    private final QueryGranularity indexGranularity;
    @JsonIgnore
    private final int targetPartitionSize;
    @JsonIgnore
    private final FirehoseFactory firehoseFactory;
    @JsonIgnore
    private final int rowFlushBoundary;

    @JsonCreator
    public IndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JsonProperty(value="spatialDimensions") List<SpatialDimensionSchema> spatialDimensions, @JsonProperty(value="aggregators") AggregatorFactory[] aggregators, @JsonProperty(value="indexGranularity") QueryGranularity indexGranularity, @JsonProperty(value="targetPartitionSize") int targetPartitionSize, @JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="rowFlushBoundary") int rowFlushBoundary) {
        super(id != null ? id : String.format("index_%s_%s", dataSource, new DateTime().toString()), dataSource, new Interval((ReadableInstant)((Interval)granularitySpec.bucketIntervals().first()).getStart(), (ReadableInstant)((Interval)granularitySpec.bucketIntervals().last()).getEnd()));
        this.granularitySpec = (GranularitySpec)Preconditions.checkNotNull((Object)granularitySpec, (Object)"granularitySpec");
        this.spatialDimensions = spatialDimensions == null ? Lists.newArrayList() : spatialDimensions;
        this.aggregators = aggregators;
        this.indexGranularity = indexGranularity == null ? QueryGranularity.NONE : indexGranularity;
        this.targetPartitionSize = targetPartitionSize;
        this.firehoseFactory = (FirehoseFactory)Preconditions.checkNotNull((Object)firehoseFactory, (Object)"firehoseFactory");
        this.rowFlushBoundary = rowFlushBoundary;
    }

    @Override
    public String getType() {
        return "index";
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        TaskLock myLock = (TaskLock)Iterables.getOnlyElement(this.getTaskLocks(toolbox));
        HashSet segments = Sets.newHashSet();
        Sets.SetView validIntervals = Sets.intersection((Set)this.granularitySpec.bucketIntervals(), this.getDataIntervals());
        if (validIntervals.isEmpty()) {
            throw new ISE("No valid data intervals found. Check your configs!", new Object[0]);
        }
        for (Interval bucket : validIntervals) {
            List<Object> shardSpecs = this.targetPartitionSize > 0 ? this.determinePartitions(bucket, this.targetPartitionSize) : ImmutableList.of((Object)new NoneShardSpec());
            Iterator i$ = shardSpecs.iterator();
            while (i$.hasNext()) {
                ShardSpec shardSpec = (ShardSpec)i$.next();
                DataSegment segment = this.generateSegment(toolbox, new Schema(this.getDataSource(), this.spatialDimensions, this.aggregators, this.indexGranularity, shardSpec), bucket, myLock.getVersion());
                segments.add(segment);
            }
        }
        toolbox.pushSegments(segments);
        return TaskStatus.success(this.getId());
    }

    private SortedSet<Interval> getDataIntervals() throws IOException {
        TreeSet retVal = Sets.newTreeSet((Comparator)Comparators.intervalsByStartThenEnd());
        try (Firehose firehose = this.firehoseFactory.connect();){
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                Interval interval = this.granularitySpec.getGranularity().bucket(new DateTime(inputRow.getTimestampFromEpoch()));
                retVal.add(interval);
            }
        }
        return retVal;
    }

    private List<ShardSpec> determinePartitions(Interval interval, int targetPartitionSize) throws IOException {
        log.info("Determining partitions for interval[%s] with targetPartitionSize[%d]", new Object[]{interval, targetPartitionSize});
        HashSet unusableDimensions = Sets.newHashSet();
        HashMap dimensionValueMultisets = Maps.newHashMap();
        try (Firehose firehose = this.firehoseFactory.connect();){
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                if (!interval.contains(inputRow.getTimestampFromEpoch())) continue;
                for (String dim : inputRow.getDimensions()) {
                    List dimValues = inputRow.getDimension(dim);
                    if (unusableDimensions.contains(dim)) continue;
                    if (dimValues.size() == 1) {
                        TreeMultiset dimensionValueMultiset = (TreeMultiset)dimensionValueMultisets.get(dim);
                        if (dimensionValueMultiset == null) {
                            dimensionValueMultiset = TreeMultiset.create();
                            dimensionValueMultisets.put(dim, dimensionValueMultiset);
                        }
                        dimensionValueMultiset.add(dimValues.get(0));
                        continue;
                    }
                    unusableDimensions.add(dim);
                    dimensionValueMultisets.remove(dim);
                }
            }
        }
        ArrayList shardSpecs = Lists.newArrayList();
        Ordering<Map.Entry<String, TreeMultiset<String>>> byCardinalityOrdering = new Ordering<Map.Entry<String, TreeMultiset<String>>>(){

            public int compare(Map.Entry<String, TreeMultiset<String>> left, Map.Entry<String, TreeMultiset<String>> right) {
                return Ints.compare((int)left.getValue().elementSet().size(), (int)right.getValue().elementSet().size());
            }
        };
        if (dimensionValueMultisets.isEmpty()) {
            log.info("No suitable partition dimension found", new Object[0]);
            shardSpecs.add(new NoneShardSpec());
        } else {
            Map.Entry partitionEntry = (Map.Entry)byCardinalityOrdering.max(dimensionValueMultisets.entrySet());
            String partitionDim = (String)partitionEntry.getKey();
            TreeMultiset partitionDimValues = (TreeMultiset)partitionEntry.getValue();
            log.info("Partitioning on dimension[%s] with cardinality[%d] over rows[%d]", new Object[]{partitionDim, partitionDimValues.elementSet().size(), partitionDimValues.size()});
            String currentPartitionStart = null;
            int currentPartitionSize = 0;
            for (String partitionDimValue : partitionDimValues.elementSet()) {
                if ((currentPartitionSize += partitionDimValues.count((Object)partitionDimValue)) < targetPartitionSize) continue;
                SingleDimensionShardSpec shardSpec = new SingleDimensionShardSpec(partitionDim, currentPartitionStart, partitionDimValue, shardSpecs.size());
                log.info("Adding shard: %s", new Object[]{shardSpec});
                shardSpecs.add(shardSpec);
                currentPartitionSize = partitionDimValues.count((Object)partitionDimValue);
                currentPartitionStart = partitionDimValue;
            }
            if (currentPartitionSize > 0) {
                Object shardSpec = shardSpecs.isEmpty() ? new NoneShardSpec() : new SingleDimensionShardSpec(partitionDim, currentPartitionStart, null, shardSpecs.size());
                log.info("Adding shard: %s", new Object[]{shardSpec});
                shardSpecs.add(shardSpec);
            }
        }
        return shardSpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSegment generateSegment(final TaskToolbox toolbox, Schema schema, Interval interval, String version) throws IOException {
        File tmpDir = new File(toolbox.getTaskWorkDir(), String.format("%s_%s_%s_%s_%s", this.getDataSource(), interval.getStart(), interval.getEnd(), version, schema.getShardSpec().getPartitionNum()));
        final CopyOnWriteArrayList pushedSegments = new CopyOnWriteArrayList();
        DataSegmentPusher wrappedDataSegmentPusher = new DataSegmentPusher(){

            public String getPathForHadoop(String dataSource) {
                return toolbox.getSegmentPusher().getPathForHadoop(dataSource);
            }

            public DataSegment push(File file, DataSegment segment) throws IOException {
                DataSegment pushedSegment = toolbox.getSegmentPusher().push(file, segment);
                pushedSegments.add(pushedSegment);
                return pushedSegment;
            }
        };
        FireDepartmentMetrics metrics = new FireDepartmentMetrics();
        Firehose firehose = this.firehoseFactory.connect();
        Plumber plumber = new YeOldePlumberSchool(interval, version, wrappedDataSegmentPusher, tmpDir).findPlumber(schema, metrics);
        int myRowFlushBoundary = this.rowFlushBoundary > 0 ? this.rowFlushBoundary : toolbox.getConfig().getDefaultRowFlushBoundary();
        try {
            plumber.startJob();
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                if (this.shouldIndex(schema, interval, inputRow)) {
                    Sink sink = plumber.getSink(inputRow.getTimestampFromEpoch());
                    if (sink == null) {
                        throw new NullPointerException(String.format("Was expecting non-null sink for timestamp[%s]", new DateTime(inputRow.getTimestampFromEpoch())));
                    }
                    int numRows = sink.add(inputRow);
                    metrics.incrementProcessed();
                    if (numRows < myRowFlushBoundary) continue;
                    plumber.persist(firehose.commit());
                    continue;
                }
                metrics.incrementThrownAway();
            }
        }
        finally {
            firehose.close();
        }
        plumber.persist(firehose.commit());
        try {
            plumber.finishJob();
        }
        catch (Throwable throwable) {
            log.info("Task[%s] interval[%s] partition[%d] took in %,d rows (%,d processed, %,d unparseable, %,d thrown away) and output %,d rows", new Object[]{this.getId(), interval, schema.getShardSpec().getPartitionNum(), metrics.processed() + metrics.unparseable() + metrics.thrownAway(), metrics.processed(), metrics.unparseable(), metrics.thrownAway(), metrics.rowOutput()});
            throw throwable;
        }
        log.info("Task[%s] interval[%s] partition[%d] took in %,d rows (%,d processed, %,d unparseable, %,d thrown away) and output %,d rows", new Object[]{this.getId(), interval, schema.getShardSpec().getPartitionNum(), metrics.processed() + metrics.unparseable() + metrics.thrownAway(), metrics.processed(), metrics.unparseable(), metrics.thrownAway(), metrics.rowOutput()});
        return (DataSegment)Iterables.getOnlyElement(pushedSegments);
    }

    private boolean shouldIndex(Schema schema, Interval interval, InputRow inputRow) {
        return interval.contains(inputRow.getTimestampFromEpoch()) && schema.getShardSpec().isInChunk(inputRow);
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    @JsonProperty
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public QueryGranularity getIndexGranularity() {
        return this.indexGranularity;
    }

    @JsonProperty
    public long getTargetPartitionSize() {
        return this.targetPartitionSize;
    }

    @JsonProperty(value="firehose")
    public FirehoseFactory getFirehoseFactory() {
        return this.firehoseFactory;
    }

    @JsonProperty
    public int getRowFlushBoundary() {
        return this.rowFlushBoundary;
    }

    @JsonProperty
    public List<SpatialDimensionSchema> getSpatialDimensions() {
        return this.spatialDimensions;
    }
}

