/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.util.Lists;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.metamx.common.logger.Logger;
import io.druid.common.utils.JodaUtils;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerConfigBuilder;
import io.druid.indexer.HadoopDruidIndexerJob;
import io.druid.indexer.HadoopDruidIndexerSchema;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.task.AbstractFixedIntervalTask;
import io.druid.initialization.Initialization;
import io.druid.server.initialization.ExtensionsConfig;
import io.druid.timeline.DataSegment;
import io.tesla.aether.TeslaAether;
import io.tesla.aether.internal.DefaultTeslaAether;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;

public class HadoopIndexTask
extends AbstractFixedIntervalTask {
    private static final Logger log = new Logger(HadoopIndexTask.class);
    private static String defaultHadoopCoordinates = "org.apache.hadoop:hadoop-core:1.0.3";
    private static final ExtensionsConfig extensionsConfig = (ExtensionsConfig)Initialization.makeStartupInjector().getInstance(ExtensionsConfig.class);
    @JsonIgnore
    private final HadoopDruidIndexerSchema schema;
    @JsonIgnore
    private final String hadoopCoordinates;

    @JsonCreator
    public HadoopIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="config") HadoopDruidIndexerSchema schema, @JsonProperty(value="hadoopCoordinates") String hadoopCoordinates) {
        super(id != null ? id : String.format("index_hadoop_%s_%s", schema.getDataSource(), new DateTime()), schema.getDataSource(), JodaUtils.umbrellaInterval((Iterable)JodaUtils.condenseIntervals((Iterable)schema.getGranularitySpec().bucketIntervals())));
        Preconditions.checkArgument((schema.getSegmentOutputPath() == null ? 1 : 0) != 0, (Object)"segmentOutputPath must be absent");
        Preconditions.checkArgument((schema.getWorkingPath() == null ? 1 : 0) != 0, (Object)"workingPath must be absent");
        Preconditions.checkArgument((schema.getUpdaterJobSpec() == null ? 1 : 0) != 0, (Object)"updaterJobSpec must be absent");
        this.schema = schema;
        this.hadoopCoordinates = hadoopCoordinates == null ? defaultHadoopCoordinates : hadoopCoordinates;
    }

    @Override
    public String getType() {
        return "index_hadoop";
    }

    @JsonProperty(value="config")
    public HadoopDruidIndexerSchema getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getHadoopCoordinates() {
        return this.hadoopCoordinates;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        DefaultTeslaAether aetherClient = Initialization.getAetherClient((ExtensionsConfig)extensionsConfig);
        URLClassLoader hadoopLoader = Initialization.getClassLoaderForCoordinates((TeslaAether)aetherClient, (String)this.hadoopCoordinates);
        ArrayList extensionURLs = Lists.newArrayList();
        for (String coordinate : extensionsConfig.getCoordinates()) {
            URLClassLoader coordinateLoader = Initialization.getClassLoaderForCoordinates((TeslaAether)aetherClient, (String)coordinate);
            extensionURLs.addAll(Arrays.asList(coordinateLoader.getURLs()));
        }
        ArrayList nonHadoopURLs = Lists.newArrayList();
        nonHadoopURLs.addAll(Arrays.asList(((URLClassLoader)HadoopIndexTask.class.getClassLoader()).getURLs()));
        ArrayList driverURLs = Lists.newArrayList();
        driverURLs.addAll(nonHadoopURLs);
        driverURLs.addAll(Arrays.asList(hadoopLoader.getURLs()));
        URLClassLoader loader = new URLClassLoader(driverURLs.toArray(new URL[driverURLs.size()]), null);
        Thread.currentThread().setContextClassLoader(loader);
        ArrayList jobUrls = Lists.newArrayList();
        jobUrls.addAll(nonHadoopURLs);
        jobUrls.addAll(extensionURLs);
        System.setProperty("druid.hadoop.internal.classpath", Joiner.on((String)File.pathSeparator).join((Iterable)jobUrls));
        Class<?> mainClass = loader.loadClass(HadoopIndexTaskInnerProcessing.class.getName());
        Method mainMethod = mainClass.getMethod("runTask", String[].class);
        TaskLock myLock = (TaskLock)Iterables.getOnlyElement(this.getTaskLocks(toolbox));
        log.info("Setting version to: %s", new Object[]{myLock.getVersion()});
        String[] args = new String[]{toolbox.getObjectMapper().writeValueAsString((Object)this.schema), myLock.getVersion(), toolbox.getConfig().getHadoopWorkingPath(), toolbox.getSegmentPusher().getPathForHadoop(this.getDataSource())};
        String segments = (String)mainMethod.invoke(null, new Object[]{args});
        if (segments != null) {
            List publishedSegments = (List)toolbox.getObjectMapper().readValue(segments, (TypeReference)new TypeReference<List<DataSegment>>(){});
            toolbox.pushSegments(publishedSegments);
            return TaskStatus.success(this.getId());
        }
        return TaskStatus.failure(this.getId());
    }

    public static class HadoopIndexTaskInnerProcessing {
        public static String runTask(String[] args) throws Exception {
            String schema = args[0];
            String version = args[1];
            String workingPath = args[2];
            String segmentOutputPath = args[3];
            HadoopDruidIndexerSchema theSchema = (HadoopDruidIndexerSchema)HadoopDruidIndexerConfig.jsonMapper.readValue(schema, HadoopDruidIndexerSchema.class);
            HadoopDruidIndexerConfig config = new HadoopDruidIndexerConfigBuilder().withSchema(theSchema).withVersion(version).withWorkingPath(workingPath).withSegmentOutputPath(segmentOutputPath).build();
            HadoopDruidIndexerJob job = new HadoopDruidIndexerJob(config);
            log.info("Starting a hadoop index generator job...", new Object[0]);
            if (job.run()) {
                return HadoopDruidIndexerConfig.jsonMapper.writeValueAsString((Object)job.getPublishedSegments());
            }
            return null;
        }
    }
}

