/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.indexing.common.actions.LockTryAcquireAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractTask;
import io.druid.indexing.common.task.TaskResource;
import org.joda.time.Interval;

public abstract class AbstractFixedIntervalTask
extends AbstractTask {
    @JsonIgnore
    private final Interval interval;

    protected AbstractFixedIntervalTask(String id, String dataSource, Interval interval) {
        this(id, id, new TaskResource(id, 1), dataSource, interval);
    }

    protected AbstractFixedIntervalTask(String id, String groupId, String dataSource, Interval interval) {
        this(id, groupId, new TaskResource(id, 1), dataSource, interval);
    }

    protected AbstractFixedIntervalTask(String id, String groupId, TaskResource taskResource, String dataSource, Interval interval) {
        super(id, groupId, taskResource, dataSource);
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        Preconditions.checkArgument((interval.toDurationMillis() > 0L ? 1 : 0) != 0, (Object)"interval empty");
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return taskActionClient.submit(new LockTryAcquireAction(this.interval)).isPresent();
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }
}

