/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.index;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.emitter.EmittingLogger;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.indexing.common.index.ChatHandler;
import io.druid.indexing.common.index.ChatHandlerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@JsonTypeName(value="receiver")
public class EventReceiverFirehoseFactory
implements FirehoseFactory {
    private static final EmittingLogger log = new EmittingLogger(EventReceiverFirehoseFactory.class);
    private static final int DEFAULT_BUFFER_SIZE = 100000;
    private final String serviceName;
    private final int bufferSize;
    private final MapInputRowParser parser;
    private final Optional<ChatHandlerProvider> chatHandlerProvider;

    @JsonCreator
    public EventReceiverFirehoseFactory(@JsonProperty(value="serviceName") String serviceName, @JsonProperty(value="bufferSize") Integer bufferSize, @JsonProperty(value="parser") MapInputRowParser parser, @JacksonInject ChatHandlerProvider chatHandlerProvider) {
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        this.bufferSize = bufferSize == null || bufferSize <= 0 ? 100000 : bufferSize;
        this.parser = (MapInputRowParser)Preconditions.checkNotNull((Object)parser, (Object)"parser");
        this.chatHandlerProvider = Optional.fromNullable((Object)chatHandlerProvider);
    }

    public Firehose connect() throws IOException {
        log.info("Connecting firehose: %s", new Object[]{this.serviceName});
        EventReceiverFirehose firehose = new EventReceiverFirehose();
        if (this.chatHandlerProvider.isPresent()) {
            log.info("Found chathandler of class[%s]", new Object[]{((ChatHandlerProvider)this.chatHandlerProvider.get()).getClass().getName()});
            ((ChatHandlerProvider)this.chatHandlerProvider.get()).register(this.serviceName, firehose);
            if (this.serviceName.contains(":")) {
                ((ChatHandlerProvider)this.chatHandlerProvider.get()).register(this.serviceName.replaceAll(".*:", ""), firehose);
            }
        } else {
            log.info("No chathandler detected", new Object[0]);
        }
        return firehose;
    }

    @JsonProperty
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty
    public int getBufferSize() {
        return this.bufferSize;
    }

    @JsonProperty
    public MapInputRowParser getParser() {
        return this.parser;
    }

    public class EventReceiverFirehose
    implements ChatHandler,
    Firehose {
        private final BlockingQueue<InputRow> buffer;
        private final Object readLock = new Object();
        private volatile InputRow nextRow = null;
        private volatile boolean closed = false;

        public EventReceiverFirehose() {
            this.buffer = new ArrayBlockingQueue<InputRow>(EventReceiverFirehoseFactory.this.bufferSize);
        }

        @POST
        @Path(value="/push-events")
        @Produces(value={"application/json"})
        public Response addAll(Collection<Map<String, Object>> events) {
            log.debug("Adding %,d events to firehose: %s", new Object[]{events.size(), EventReceiverFirehoseFactory.this.serviceName});
            ArrayList rows = Lists.newArrayList();
            for (Map<String, Object> event : events) {
                rows.add(EventReceiverFirehoseFactory.this.parser.parse(event));
            }
            try {
                for (InputRow row : rows) {
                    boolean added = false;
                    while (!this.closed && !added) {
                        added = this.buffer.offer(row, 500L, TimeUnit.MILLISECONDS);
                    }
                    if (added) continue;
                    throw new IllegalStateException("Cannot add events to closed firehose!");
                }
                return Response.ok().entity((Object)ImmutableMap.of((Object)"eventCount", (Object)events.size())).build();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMore() {
            Object object = this.readLock;
            synchronized (object) {
                try {
                    while (!this.closed && this.nextRow == null) {
                        this.nextRow = this.buffer.poll(500L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Throwables.propagate((Throwable)e);
                }
                return this.nextRow != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputRow nextRow() {
            Object object = this.readLock;
            synchronized (object) {
                InputRow row = this.nextRow;
                if (row == null) {
                    throw new NoSuchElementException();
                }
                this.nextRow = null;
                return row;
            }
        }

        public Runnable commit() {
            return new Runnable(){

                @Override
                public void run() {
                }
            };
        }

        public void close() throws IOException {
            log.info("Firehose closing.", new Object[0]);
            this.closed = true;
            if (EventReceiverFirehoseFactory.this.chatHandlerProvider.isPresent()) {
                ((ChatHandlerProvider)EventReceiverFirehoseFactory.this.chatHandlerProvider.get()).unregister(EventReceiverFirehoseFactory.this.serviceName);
            }
        }
    }
}

