/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;

public class TaskConfig {
    @JsonProperty
    private final String baseDir;
    @JsonProperty
    private final File baseTaskDir;
    @JsonProperty
    private final String hadoopWorkingPath;
    @JsonProperty
    private final int defaultRowFlushBoundary;

    @JsonCreator
    public TaskConfig(@JsonProperty(value="baseDir") String baseDir, @JsonProperty(value="baseTaskDir") String baseTaskDir, @JsonProperty(value="hadoopWorkingPath") String hadoopWorkingPath, @JsonProperty(value="defaultRowFlushBoundary") Integer defaultRowFlushBoundary) {
        this.baseDir = baseDir == null ? "/tmp" : baseDir;
        this.baseTaskDir = new File(this.defaultDir(baseTaskDir, "persistent/task"));
        this.hadoopWorkingPath = this.defaultDir(hadoopWorkingPath, "druid-indexing");
        this.defaultRowFlushBoundary = defaultRowFlushBoundary == null ? 500000 : defaultRowFlushBoundary;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public File getBaseTaskDir() {
        return this.baseTaskDir;
    }

    public String getHadoopWorkingPath() {
        return this.hadoopWorkingPath;
    }

    public int getDefaultRowFlushBoundary() {
        return this.defaultRowFlushBoundary;
    }

    private String defaultDir(String configParameter, String defaultVal) {
        if (configParameter == null) {
            return String.format("%s/%s", this.getBaseDir(), defaultVal);
        }
        return configParameter;
    }
}

