/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.IndexerDBCoordinator;
import io.druid.indexing.overlord.TaskLockbox;
import io.druid.timeline.DataSegment;
import java.util.List;
import java.util.Set;
import org.joda.time.ReadableInterval;

public class TaskActionToolbox {
    private final TaskLockbox taskLockbox;
    private final IndexerDBCoordinator indexerDBCoordinator;
    private final ServiceEmitter emitter;

    @Inject
    public TaskActionToolbox(TaskLockbox taskLockbox, IndexerDBCoordinator indexerDBCoordinator, ServiceEmitter emitter) {
        this.taskLockbox = taskLockbox;
        this.indexerDBCoordinator = indexerDBCoordinator;
        this.emitter = emitter;
    }

    public TaskLockbox getTaskLockbox() {
        return this.taskLockbox;
    }

    public IndexerDBCoordinator getIndexerDBCoordinator() {
        return this.indexerDBCoordinator;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public boolean segmentsAreFromSamePartitionSet(Set<DataSegment> segments) {
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"segments nonempty");
        DataSegment firstSegment = segments.iterator().next();
        for (DataSegment segment : segments) {
            if (segment.getDataSource().equals(firstSegment.getDataSource()) && segment.getInterval().equals((Object)firstSegment.getInterval()) && segment.getVersion().equals(firstSegment.getVersion())) continue;
            return false;
        }
        return true;
    }

    public void verifyTaskLocksAndSinglePartitionSettitude(Task task, Set<DataSegment> segments, boolean allowOlderVersions) {
        if (!this.taskLockCoversSegments(task, segments, allowOlderVersions)) {
            throw new ISE("Segments not covered by locks for task: %s", new Object[]{task.getId()});
        }
        if (!this.segmentsAreFromSamePartitionSet(segments)) {
            throw new ISE("Segments are not in the same partition set: %s", new Object[]{segments});
        }
    }

    public boolean taskLockCoversSegments(Task task, Set<DataSegment> segments, final boolean allowOlderVersions) {
        List<TaskLock> taskLocks = this.getTaskLockbox().findLocksForTask(task);
        for (final DataSegment segment : segments) {
            boolean ok = Iterables.any(taskLocks, (Predicate)new Predicate<TaskLock>(){

                public boolean apply(TaskLock taskLock) {
                    boolean versionOk = allowOlderVersions ? taskLock.getVersion().compareTo(segment.getVersion()) >= 0 : taskLock.getVersion().equals(segment.getVersion());
                    return versionOk && taskLock.getDataSource().equals(segment.getDataSource()) && taskLock.getInterval().contains((ReadableInterval)segment.getInterval());
                }
            });
            if (ok) continue;
            return false;
        }
        return true;
    }
}

