/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.ToStringResponseHandler;
import io.druid.client.selector.Server;
import io.druid.curator.discovery.ServerDiscoverySelector;
import io.druid.indexing.common.RetryPolicy;
import io.druid.indexing.common.RetryPolicyFactory;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.actions.TaskActionHolder;
import io.druid.indexing.common.task.Task;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.jboss.netty.channel.ChannelException;
import org.joda.time.Duration;

public class RemoteTaskActionClient
implements TaskActionClient {
    private final Task task;
    private final HttpClient httpClient;
    private final ServerDiscoverySelector selector;
    private final RetryPolicyFactory retryPolicyFactory;
    private final ObjectMapper jsonMapper;
    private static final Logger log = new Logger(RemoteTaskActionClient.class);

    public RemoteTaskActionClient(Task task, HttpClient httpClient, ServerDiscoverySelector selector, RetryPolicyFactory retryPolicyFactory, ObjectMapper jsonMapper) {
        this.task = task;
        this.httpClient = httpClient;
        this.selector = selector;
        this.retryPolicyFactory = retryPolicyFactory;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public <RetType> RetType submit(TaskAction<RetType> taskAction) throws IOException {
        log.info("Performing action for task[%s]: %s", new Object[]{this.task.getId(), taskAction});
        byte[] dataToSend = this.jsonMapper.writeValueAsBytes(new TaskActionHolder(this.task, taskAction));
        RetryPolicy retryPolicy = this.retryPolicyFactory.makeRetryPolicy();
        while (true) {
            try {
                String response;
                URI serviceUri;
                try {
                    serviceUri = this.getServiceUri();
                }
                catch (Exception e) {
                    throw new IOException("Failed to locate service uri", e);
                }
                log.info("Submitting action for task[%s] to overlord[%s]: %s", new Object[]{this.task.getId(), serviceUri, taskAction});
                try {
                    response = (String)this.httpClient.post(serviceUri.toURL()).setContent("application/json", dataToSend).go((HttpResponseHandler)new ToStringResponseHandler(Charsets.UTF_8)).get();
                }
                catch (Exception e) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), ChannelException.class);
                    throw Throwables.propagate((Throwable)e);
                }
                Map responseDict = (Map)this.jsonMapper.readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
                return (RetType)this.jsonMapper.convertValue(responseDict.get("result"), taskAction.getReturnTypeReference());
            }
            catch (IOException | ChannelException e) {
                log.warn(e, "Exception submitting action for task[%s]", new Object[]{this.task.getId()});
                Duration delay = retryPolicy.getAndIncrementRetryDelay();
                if (delay == null) {
                    throw e;
                }
                try {
                    long sleepTime = delay.getMillis();
                    log.info("Will try again in [%s].", new Object[]{new Duration(sleepTime).toString()});
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
            }
        }
    }

    private URI getServiceUri() throws Exception {
        Server instance = this.selector.pick();
        if (instance == null) {
            throw new ISE("Cannot find instance of indexer to talk to!", new Object[0]);
        }
        return new URI(String.format("%s://%s%s", instance.getScheme(), instance.getHost(), "/druid/indexer/v1/action"));
    }
}

