/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.metrics.MonitorScheduler;
import io.druid.client.ServerView;
import io.druid.guice.annotations.Processing;
import io.druid.indexing.common.SegmentLoaderFactory;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.common.task.Task;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.loading.DataSegmentArchiver;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.DataSegmentMover;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.server.coordination.DataSegmentAnnouncer;
import java.io.File;
import java.util.concurrent.ExecutorService;

public class TaskToolboxFactory {
    private final TaskConfig config;
    private final TaskActionClientFactory taskActionClientFactory;
    private final ServiceEmitter emitter;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final ServerView newSegmentServerView;
    private final QueryRunnerFactoryConglomerate queryRunnerFactoryConglomerate;
    private final ExecutorService queryExecutorService;
    private final MonitorScheduler monitorScheduler;
    private final SegmentLoaderFactory segmentLoaderFactory;
    private final ObjectMapper objectMapper;

    @Inject
    public TaskToolboxFactory(TaskConfig config, TaskActionClientFactory taskActionClientFactory, ServiceEmitter emitter, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, ServerView newSegmentServerView, QueryRunnerFactoryConglomerate queryRunnerFactoryConglomerate, @Processing ExecutorService queryExecutorService, MonitorScheduler monitorScheduler, SegmentLoaderFactory segmentLoaderFactory, ObjectMapper objectMapper) {
        this.config = config;
        this.taskActionClientFactory = taskActionClientFactory;
        this.emitter = emitter;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.newSegmentServerView = newSegmentServerView;
        this.queryRunnerFactoryConglomerate = queryRunnerFactoryConglomerate;
        this.queryExecutorService = queryExecutorService;
        this.monitorScheduler = monitorScheduler;
        this.segmentLoaderFactory = segmentLoaderFactory;
        this.objectMapper = objectMapper;
    }

    public TaskToolbox build(Task task) {
        File taskWorkDir = new File(new File(this.config.getBaseTaskDir(), task.getId()), "work");
        return new TaskToolbox(this.config, task, this.taskActionClientFactory, this.emitter, this.segmentPusher, this.dataSegmentKiller, this.dataSegmentMover, this.dataSegmentArchiver, this.segmentAnnouncer, this.newSegmentServerView, this.queryRunnerFactoryConglomerate, this.queryExecutorService, this.monitorScheduler, this.segmentLoaderFactory.manufacturate(taskWorkDir), this.objectMapper, taskWorkDir);
    }
}

