/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client.pool;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.metamx.http.client.pool.ResourceContainer;
import com.metamx.http.client.pool.ResourceFactory;
import com.metamx.http.client.pool.ResourcePoolConfig;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class ResourcePool<K, V>
implements Closeable {
    private static final Logger log = Logger.getLogger(ResourcePool.class);
    private final ConcurrentMap<K, ImmediateCreationResourceHolder<K, V>> pool;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ResourcePool(final ResourceFactory<K, V> factory, final ResourcePoolConfig config) {
        this.pool = new MapMaker().makeComputingMap(new Function<K, ImmediateCreationResourceHolder<K, V>>(){

            public ImmediateCreationResourceHolder<K, V> apply(K input) {
                return new ImmediateCreationResourceHolder(config.getMaxPerKey(), input, factory);
            }
        });
    }

    public ResourceContainer<V> take(final K key) {
        if (this.closed.get()) {
            log.error((Object)String.format("take(%s) called even though I'm closed.", key));
            return null;
        }
        final ImmediateCreationResourceHolder holder = (ImmediateCreationResourceHolder)this.pool.get(key);
        final Object value = holder.get();
        return new ResourceContainer<V>(){
            private final AtomicBoolean returned = new AtomicBoolean(false);

            @Override
            public V get() {
                Preconditions.checkState((!this.returned.get() ? 1 : 0) != 0, (String)"Resource for key[%s] has been returned, cannot get().", (Object[])new Object[]{key});
                return value;
            }

            @Override
            public void returnResource() {
                if (this.returned.getAndSet(true)) {
                    log.warn((Object)String.format("Resource at key[%s] was returned multiple times?", key));
                } else {
                    holder.giveBack(value);
                }
            }

            protected void finalize() throws Throwable {
                if (!this.returned.get()) {
                    log.warn((Object)String.format("Resource[%s] at key[%s] was not returned before Container was finalized, potential resource leak.", value, key));
                    this.returnResource();
                }
                super.finalize();
            }
        };
    }

    @Override
    public void close() {
        this.closed.set(true);
        for (Object k : this.pool.keySet()) {
            ((ImmediateCreationResourceHolder)this.pool.remove(k)).close();
        }
    }

    private static class ImmediateCreationResourceHolder<K, V> {
        private final int maxSize;
        private final K key;
        private final ResourceFactory<K, V> factory;
        private final LinkedList<V> objectList;
        private boolean closed = false;

        private ImmediateCreationResourceHolder(int maxSize, K key, ResourceFactory<K, V> factory) {
            this.maxSize = maxSize;
            this.key = key;
            this.factory = factory;
            this.objectList = new LinkedList();
            for (int i = 0; i < maxSize; ++i) {
                this.objectList.addLast(factory.generate(key));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V get() {
            V retVal;
            ImmediateCreationResourceHolder immediateCreationResourceHolder = this;
            synchronized (immediateCreationResourceHolder) {
                if (this.closed) {
                    log.info((Object)String.format("get() called even though I'm closed. key[%s]", this.key));
                    return null;
                }
                while (this.objectList.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        return null;
                    }
                }
                retVal = this.objectList.removeFirst();
            }
            if (!this.factory.isGood(retVal)) {
                this.factory.close(retVal);
                return this.factory.generate(this.key);
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void giveBack(V object) {
            ImmediateCreationResourceHolder immediateCreationResourceHolder = this;
            synchronized (immediateCreationResourceHolder) {
                if (this.closed) {
                    log.info((Object)String.format("giveBack called after being closed. key[%s]", this.key));
                    this.factory.close(object);
                    return;
                }
                if (this.objectList.size() >= this.maxSize) {
                    if (this.objectList.contains(object)) {
                        log.warn((Object)String.format("Returning object[%s] at key[%s] that has already been returned!? Skipping", object, this.key), (Throwable)new Exception("Exception for stacktrace"));
                    } else {
                        log.warn((Object)String.format("Returning object[%s] at key[%s] even though we already have all that we can hold[%s]!? Skipping", object, this.key, this.objectList), (Throwable)new Exception("Exception for stacktrace"));
                    }
                    return;
                }
                this.objectList.addLast(object);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            ImmediateCreationResourceHolder immediateCreationResourceHolder = this;
            synchronized (immediateCreationResourceHolder) {
                this.closed = true;
                while (!this.objectList.isEmpty()) {
                    this.factory.close(this.objectList.removeFirst());
                }
            }
        }
    }
}

