/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client.io;

import com.metamx.common.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class AppendableByteArrayInputStream
extends InputStream {
    private static final Logger log = new Logger(AppendableByteArrayInputStream.class);
    private final LinkedList<byte[]> bytes = new LinkedList();
    private final SingleByteReaderDoer singleByteReaderDoer = new SingleByteReaderDoer();
    private volatile boolean done = false;
    private volatile int available = 0;
    private byte[] curr = new byte[0];
    private int currIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte[] bytesToAdd) {
        if (bytesToAdd.length == 0) {
            return;
        }
        SingleByteReaderDoer singleByteReaderDoer = this.singleByteReaderDoer;
        synchronized (singleByteReaderDoer) {
            this.bytes.addLast(bytesToAdd);
            this.available += bytesToAdd.length;
            this.singleByteReaderDoer.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        SingleByteReaderDoer singleByteReaderDoer = this.singleByteReaderDoer;
        synchronized (singleByteReaderDoer) {
            this.done = true;
            this.singleByteReaderDoer.notify();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.scanThroughBytesAndDoSomething(1L, this.singleByteReaderDoer) == 0L) {
            return -1;
        }
        return this.singleByteReaderDoer.getRetVal();
    }

    @Override
    public int read(final byte[] b, final int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        long retVal = this.scanThroughBytesAndDoSomething(len, new Doer(){
            int currOff;
            {
                this.currOff = off;
            }

            @Override
            public void doSomethingWithByteArray(int numRead) {
                System.arraycopy(AppendableByteArrayInputStream.this.curr, AppendableByteArrayInputStream.this.currIndex, b, this.currOff, numRead);
                this.currOff += numRead;
            }
        });
        return retVal == 0L ? -1 : (int)retVal;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.scanThroughBytesAndDoSomething(n, new Doer(){

            @Override
            public void doSomethingWithByteArray(int numToScan) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long scanThroughBytesAndDoSomething(long numToScan, Doer doer) throws IOException {
        long numScanned = 0L;
        long numPulled = 0L;
        while (numToScan > numScanned) {
            if (this.currIndex >= this.curr.length) {
                SingleByteReaderDoer singleByteReaderDoer = this.singleByteReaderDoer;
                synchronized (singleByteReaderDoer) {
                    if (this.bytes.isEmpty()) {
                        if (this.done) {
                            break;
                        }
                        try {
                            this.available = (int)((long)this.available - numPulled);
                            numPulled = 0L;
                            this.singleByteReaderDoer.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Interrupted!");
                        }
                    }
                    if (this.bytes.isEmpty()) {
                        if (this.done) {
                            break;
                        }
                        log.debug("bytes was empty, but read thread was awakened without being done.  This shouldn't happen.", new Object[0]);
                        continue;
                    }
                    this.curr = this.bytes.removeFirst();
                    this.currIndex = 0;
                }
            }
            long numToPullFromCurr = Math.min((long)(this.curr.length - this.currIndex), numToScan - numScanned);
            doer.doSomethingWithByteArray((int)numToPullFromCurr);
            numScanned += numToPullFromCurr;
            this.currIndex = (int)((long)this.currIndex + numToPullFromCurr);
            numPulled += numToPullFromCurr;
        }
        SingleByteReaderDoer singleByteReaderDoer = this.singleByteReaderDoer;
        synchronized (singleByteReaderDoer) {
            this.available = (int)((long)this.available - numPulled);
        }
        return numScanned;
    }

    @Override
    public int available() throws IOException {
        return this.available;
    }

    private class SingleByteReaderDoer
    implements Doer {
        private int retVal;

        @Override
        public void doSomethingWithByteArray(int numToScan) {
            this.retVal = AppendableByteArrayInputStream.this.curr[AppendableByteArrayInputStream.this.currIndex];
        }

        public int getRetVal() {
            return this.retVal;
        }
    }

    private static interface Doer {
        public void doSomethingWithByteArray(int var1);
    }
}

