/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client;

import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ListenableFuture;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.Request;
import com.metamx.http.client.response.HttpResponseHandler;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.handler.codec.base64.Base64;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class RequestBuilder {
    private static final ChannelBufferFactory factory = HeapChannelBufferFactory.getInstance();
    private final HttpClient client;
    private final HttpMethod method;
    private final URL url;
    private final Multimap<String, Object> headers = Multimaps.newListMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<List<Object>>(){

        public List<Object> get() {
            return Lists.newArrayList();
        }
    });
    private volatile ChannelBuffer content = null;

    public RequestBuilder(HttpClient client, HttpMethod method, URL url) {
        this.client = client;
        this.method = method;
        this.url = url;
    }

    public RequestBuilder setHeader(String header, Object value) {
        this.headers.replaceValues((Object)header, Arrays.asList(value));
        return this;
    }

    public RequestBuilder setHeaderValues(String header, Iterable<Object> value) {
        this.headers.replaceValues((Object)header, value);
        return this;
    }

    public RequestBuilder addHeader(String header, Object value) {
        this.headers.put((Object)header, value);
        return this;
    }

    public RequestBuilder addHeaderValues(String header, Iterable<Object> value) {
        this.headers.putAll((Object)header, value);
        return this;
    }

    public RequestBuilder setContent(byte[] bytes) {
        return this.setContent(null, bytes);
    }

    public RequestBuilder setContent(byte[] bytes, int offset, int length) {
        return this.setContent(null, bytes, offset, length);
    }

    public RequestBuilder setContent(ChannelBuffer content) {
        return this.setContent(null, content);
    }

    public RequestBuilder setContent(String contentType, byte[] bytes) {
        return this.setContent(contentType, bytes, 0, bytes.length);
    }

    public RequestBuilder setContent(String contentType, byte[] bytes, int offset, int length) {
        return this.setContent(contentType, factory.getBuffer(bytes, offset, length));
    }

    public RequestBuilder setContent(String contentType, ChannelBuffer content) {
        if (contentType != null) {
            this.addHeader("Content-Type", contentType);
        }
        this.content = content;
        this.setHeader("Content-Length", content.writerIndex());
        return this;
    }

    public RequestBuilder setBasicAuthentication(String username, String password) {
        String base64Value = this.base64Encode(String.format("%s:%s", username, password));
        this.setHeader("Authorization", String.format("Basic %s", base64Value));
        return this;
    }

    private String base64Encode(String value) {
        ChannelBufferFactory bufferFactory = HeapChannelBufferFactory.getInstance();
        return Base64.encode((ChannelBuffer)bufferFactory.getBuffer(ByteBuffer.wrap(value.getBytes(Charsets.UTF_8)))).toString(Charsets.UTF_8);
    }

    public <IntermediateType, Final> ListenableFuture<Final> go(HttpResponseHandler<IntermediateType, Final> responseHandler) {
        return this.client.go(new Request<IntermediateType, Final>(this.method, this.url, this.headers, this.content, responseHandler));
    }
}

