/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.HttpClientConfig;
import com.metamx.http.client.netty.HttpClientPipelineFactory;
import com.metamx.http.client.pool.ChannelResourceFactory;
import com.metamx.http.client.pool.ResourcePool;
import com.metamx.http.client.pool.ResourcePoolConfig;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Log4JLoggerFactory;
import org.joda.time.Duration;

public class HttpClientInit {
    public static HttpClient createClient(HttpClientConfig config, Lifecycle lifecycle) {
        try {
            return (HttpClient)lifecycle.addMaybeStartManagedInstance((Object)new HttpClient(new ResourcePool<String, ChannelFuture>(new ChannelResourceFactory(HttpClientInit.createBootstrap(lifecycle), config.getSslContext()), new ResourcePoolConfig(config.getNumConnections()))).withReadTimeout(config.getReadTimeout()));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Deprecated
    public static HttpClient createClient(ResourcePoolConfig config, SSLContext sslContext, Lifecycle lifecycle) {
        return HttpClientInit.createClient(new HttpClientConfig(config.getMaxPerKey(), sslContext, Duration.ZERO), lifecycle);
    }

    public static ClientBootstrap createBootstrap(Lifecycle lifecycle) {
        final ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Netty-Boss-%s").build()), (Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Netty-Worker-%s").build())));
        bootstrap.setOption("keepAlive", (Object)true);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpClientPipelineFactory());
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
        try {
            lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                public void start() throws Exception {
                }

                public void stop() {
                    bootstrap.releaseExternalResources();
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return bootstrap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SSLContext sslContextWithTrustedKeyStore(String keyStorePath, String keyStorePassword) {
        SSLContext sSLContext;
        FileInputStream in = null;
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            in = new FileInputStream(keyStorePath);
            ks.load(in, keyStorePassword.toCharArray());
            in.close();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            sSLContext = sslContext;
        }
        catch (CertificateException e) {
            try {
                throw Throwables.propagate((Throwable)e);
                catch (NoSuchAlgorithmException e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
                catch (KeyStoreException e3) {
                    throw Throwables.propagate((Throwable)e3);
                }
                catch (KeyManagementException e4) {
                    throw Throwables.propagate((Throwable)e4);
                }
                catch (FileNotFoundException e5) {
                    throw Throwables.propagate((Throwable)e5);
                }
                catch (IOException e6) {
                    throw Throwables.propagate((Throwable)e6);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        return sSLContext;
    }
}

