/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.metamx.common.IAE;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.http.client.HttpClientConfig;
import com.metamx.http.client.HttpClientInit;
import com.metamx.http.client.Request;
import com.metamx.http.client.RequestBuilder;
import com.metamx.http.client.auth.Credentials;
import com.metamx.http.client.netty.HandshakeRememberingSslHandler;
import com.metamx.http.client.pool.ResourceContainer;
import com.metamx.http.client.pool.ResourcePool;
import com.metamx.http.client.pool.ResourcePoolConfig;
import com.metamx.http.client.response.ClientResponse;
import com.metamx.http.client.response.HttpResponseHandler;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.joda.time.Duration;

public class HttpClient {
    private static final Logger log = Logger.getLogger(HttpClient.class);
    private static final String READ_TIMEOUT_HANDLER_NAME = "read-timeout";
    private static final String LAST_HANDLER_NAME = "last-handler";
    private final Timer timer;
    private final ResourcePool<String, ChannelFuture> pool;
    private final boolean enforceSSL;
    private final Credentials credentials;
    private final Duration readTimeout;

    public HttpClient(ResourcePool<String, ChannelFuture> pool) {
        this(pool, false, null, null);
    }

    private HttpClient(ResourcePool<String, ChannelFuture> pool, boolean enforceSSL, Credentials credentials, Duration readTimeout) {
        this.pool = pool;
        this.enforceSSL = enforceSSL;
        this.credentials = credentials;
        this.readTimeout = readTimeout;
        this.timer = readTimeout != null && readTimeout.getMillis() > 0L ? new HashedWheelTimer(new ThreadFactoryBuilder().setDaemon(true).build()) : null;
    }

    @LifecycleStart
    public void start() {
    }

    @LifecycleStop
    public void stop() {
        if (this.hasTimeout()) {
            this.timer.stop();
        }
        this.pool.close();
    }

    public HttpClient secureClient() {
        return new HttpClient(this.pool, true, this.credentials, this.readTimeout);
    }

    public HttpClient withCredentials(Credentials credentials) {
        return new HttpClient(this.pool, this.enforceSSL, credentials, this.readTimeout);
    }

    public HttpClient withReadTimeout(Duration readTimeout) {
        return new HttpClient(this.pool, this.enforceSSL, this.credentials, readTimeout);
    }

    public <Intermediate, Final> ListenableFuture<Final> get(URL url, HttpResponseHandler<Intermediate, Final> httpResponseHandler) {
        return this.get(url).go(httpResponseHandler);
    }

    public <Intermediate, Final> ListenableFuture<Final> get(URL url, ImmutableMultimap<String, Object> headers, HttpResponseHandler<Intermediate, Final> httpResponseHandler) {
        RequestBuilder builder = this.get(url);
        for (Map.Entry entry : headers.asMap().entrySet()) {
            builder.setHeaderValues((String)entry.getKey(), (Iterable)entry.getValue());
        }
        return builder.go(httpResponseHandler);
    }

    public <Intermediate, Final> ListenableFuture<Final> post(URL url, ChannelBuffer content, ImmutableMultimap<String, Object> headers, HttpResponseHandler<Intermediate, Final> httpResponseHandler) {
        RequestBuilder builder = this.post(url);
        builder.setContent(content);
        for (Map.Entry entry : headers.asMap().entrySet()) {
            builder.setHeaderValues((String)entry.getKey(), (Iterable)entry.getValue());
        }
        return builder.go(httpResponseHandler);
    }

    public RequestBuilder get(URL url) {
        return this.makeBuilder(HttpMethod.GET, url);
    }

    public RequestBuilder post(URL url) {
        return this.makeBuilder(HttpMethod.POST, url);
    }

    public RequestBuilder put(URL url) {
        return this.makeBuilder(HttpMethod.PUT, url);
    }

    private RequestBuilder makeBuilder(HttpMethod method, URL url) {
        if (this.enforceSSL && !"https".equals(url.getProtocol())) {
            throw new IllegalArgumentException(String.format("Requests must be over https, got[%s].", url));
        }
        RequestBuilder builder = new RequestBuilder(this, method, url);
        if (this.credentials != null) {
            this.credentials.addCredentials(builder);
        }
        return builder;
    }

    public <Intermediate, Final> ListenableFuture<Final> go(Request<Intermediate, Final> request) {
        String hostKey;
        ResourceContainer<ChannelFuture> channelResourceContainer;
        Channel channel;
        HandshakeRememberingSslHandler sslHandler;
        HttpMethod method = request.getMethod();
        URL url = request.getUrl();
        Multimap<String, Object> headers = request.getHeaders();
        final HttpResponseHandler<Intermediate, Final> httpResponseHandler = request.getHandler();
        final String requestDesc = String.format("%s %s", method, url);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] starting", requestDesc));
        }
        if ((sslHandler = (HandshakeRememberingSslHandler)(channel = (channelResourceContainer = this.pool.take(hostKey = this.getPoolKey(url))).get().awaitUninterruptibly().getChannel()).getPipeline().get(HandshakeRememberingSslHandler.class)) != null) {
            try {
                sslHandler.getHandshakeFutureOrHandshake().await();
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, url.getFile());
        if (!headers.containsKey((Object)"Host")) {
            httpRequest.addHeader("Host", (Object)this.getHost(url));
        }
        for (Map.Entry entry : headers.asMap().entrySet()) {
            String key = (String)entry.getKey();
            for (Object obj : (Collection)entry.getValue()) {
                httpRequest.addHeader(key, obj);
            }
        }
        if (request.hasContent()) {
            httpRequest.setContent(request.getContent());
        }
        final SettableFuture retVal = SettableFuture.create();
        if (this.hasTimeout()) {
            channel.getPipeline().addLast(READ_TIMEOUT_HANDLER_NAME, (ChannelHandler)new ReadTimeoutHandler(this.timer, this.readTimeout.getMillis(), TimeUnit.MILLISECONDS));
        }
        channel.getPipeline().addLast(LAST_HANDLER_NAME, (ChannelHandler)new SimpleChannelUpstreamHandler(){
            private volatile ClientResponse<Intermediate> response = null;

            public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
                block13: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("[%s] messageReceived: %s", requestDesc, e.getMessage()));
                    }
                    try {
                        Object msg = e.getMessage();
                        if (msg instanceof HttpResponse) {
                            HttpResponse httpResponse = (HttpResponse)msg;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("[%s] Got response: %s", requestDesc, httpResponse.getStatus()));
                            }
                            this.response = httpResponseHandler.handleResponse(httpResponse);
                            if (this.response.isFinished()) {
                                retVal.set(this.response.getObj());
                            }
                            if (!httpResponse.isChunked()) {
                                this.finishRequest();
                            }
                            break block13;
                        }
                        if (msg instanceof HttpChunk) {
                            HttpChunk httpChunk = (HttpChunk)msg;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("[%s] Got chunk: %sB, last=%s", requestDesc, httpChunk.getContent().readableBytes(), httpChunk.isLast()));
                            }
                            if (httpChunk.isLast()) {
                                this.finishRequest();
                            } else {
                                this.response = httpResponseHandler.handleChunk(this.response, httpChunk);
                                if (this.response.isFinished() && !retVal.isDone()) {
                                    retVal.set(this.response.getObj());
                                }
                            }
                            break block13;
                        }
                        throw new IllegalStateException(String.format("Unknown message type[%s]", msg.getClass()));
                    }
                    catch (Exception ex) {
                        log.warn((Object)String.format("[%s] Exception thrown while processing message, closing channel.", requestDesc), (Throwable)ex);
                        if (!retVal.isDone()) {
                            retVal.set(null);
                        }
                        channel.close();
                        channelResourceContainer.returnResource();
                        throw ex;
                    }
                }
            }

            private void finishRequest() {
                ClientResponse finalResponse = httpResponseHandler.done(this.response);
                if (!finalResponse.isFinished()) {
                    throw new IllegalStateException(String.format("[%s] Didn't get a completed ClientResponse Object from [%s]", requestDesc, httpResponseHandler.getClass()));
                }
                if (!retVal.isDone()) {
                    retVal.set(finalResponse.getObj());
                }
                this.removeHandlers();
                channelResourceContainer.returnResource();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void exceptionCaught(ChannelHandlerContext context, ExceptionEvent event) throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("[%s] Caught exception", requestDesc), event.getCause());
                }
                retVal.setException(event.getCause());
                this.removeHandlers();
                try {
                    channel.close();
                }
                catch (Exception exception) {
                }
                finally {
                    channelResourceContainer.returnResource();
                }
                context.sendUpstream((ChannelEvent)event);
            }

            public void channelDisconnected(ChannelHandlerContext context, ChannelStateEvent event) throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("[%s] Channel disconnected", requestDesc));
                }
                channel.close();
                channelResourceContainer.returnResource();
                if (!retVal.isDone()) {
                    log.warn((Object)String.format("[%s] Channel disconnected before response complete", requestDesc));
                    retVal.setException((Throwable)new ChannelException("Channel disconnected"));
                }
                context.sendUpstream((ChannelEvent)event);
            }

            private void removeHandlers() {
                if (HttpClient.this.hasTimeout()) {
                    channel.getPipeline().remove(HttpClient.READ_TIMEOUT_HANDLER_NAME);
                }
                channel.getPipeline().remove(HttpClient.LAST_HANDLER_NAME);
            }
        });
        channel.write((Object)httpRequest);
        return retVal;
    }

    private boolean hasTimeout() {
        return this.timer != null;
    }

    private String getHost(URL url) {
        int port = url.getPort();
        if (port == -1) {
            String protocol = url.getProtocol();
            if ("http".equalsIgnoreCase(protocol)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(protocol)) {
                port = 443;
            } else {
                throw new IAE("Cannot figure out default port for protocol[%s], please set Host header.", new Object[]{protocol});
            }
        }
        return String.format("%s:%s", url.getHost(), port);
    }

    private String getPoolKey(URL url) {
        return String.format("%s://%s:%s", url.getProtocol(), url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort());
    }

    @Deprecated
    public static HttpClient create(ResourcePoolConfig config, Lifecycle lifecycle) {
        return HttpClientInit.createClient(HttpClientConfig.builder().withNumConnections(config.getMaxPerKey()).build(), lifecycle);
    }

    @Deprecated
    public static ClientBootstrap createBootstrap(Lifecycle lifecycle) {
        return HttpClientInit.createBootstrap(lifecycle);
    }
}

