/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.data.input.InputRow;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.StringPartitionChunk;
import java.util.List;

public class SingleDimensionShardSpec
implements ShardSpec {
    private String dimension;
    private String start;
    private String end;
    private int partitionNum;

    public SingleDimensionShardSpec() {
        this(null, null, null, -1);
    }

    public SingleDimensionShardSpec(String dimension, String start, String end, int partitionNum) {
        this.dimension = dimension;
        this.start = start;
        this.end = end;
        this.partitionNum = partitionNum;
    }

    @JsonProperty(value="dimension")
    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    @JsonProperty(value="start")
    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    @JsonProperty(value="end")
    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionNum;
    }

    public void setPartitionNum(int partitionNum) {
        this.partitionNum = partitionNum;
    }

    public <T> PartitionChunk<T> createChunk(T obj) {
        return new StringPartitionChunk(this.start, this.end, this.partitionNum, obj);
    }

    public boolean isInChunk(InputRow inputRow) {
        List values = inputRow.getDimension(this.dimension);
        if (values == null || values.size() != 1) {
            return this.checkValue(null);
        }
        return this.checkValue((String)values.get(0));
    }

    private boolean checkValue(String value) {
        if (value == null) {
            return this.start == null;
        }
        if (this.start == null) {
            return this.end == null || value.compareTo(this.end) < 0;
        }
        return value.compareTo(this.start) >= 0 && (this.end == null || value.compareTo(this.end) < 0);
    }

    public String toString() {
        return "SingleDimensionShardSpec{dimension='" + this.dimension + '\'' + ", start='" + this.start + '\'' + ", end='" + this.end + '\'' + ", partitionNum=" + this.partitionNum + '}';
    }
}

