/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import com.metamx.emitter.core.Event;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceEventBuilder;
import io.druid.query.Query;
import io.druid.server.RequestLogLine;
import io.druid.server.log.RequestLogger;
import java.util.Map;
import org.joda.time.DateTime;

public class EmittingRequestLogger
implements RequestLogger {
    final ServiceEmitter emitter;
    final String feed;

    public EmittingRequestLogger(ServiceEmitter emitter, String feed) {
        this.emitter = emitter;
        this.feed = feed;
    }

    @Override
    public void log(RequestLogLine requestLogLine) throws Exception {
        this.emitter.emit((ServiceEventBuilder)new RequestLogEventBuilder(this.feed, requestLogLine));
    }

    private class RequestLogEventBuilder
    implements ServiceEventBuilder {
        private final String feed;
        private final RequestLogLine requestLogLine;

        public RequestLogEventBuilder(String feed, RequestLogLine requestLogLine) {
            this.feed = feed;
            this.requestLogLine = requestLogLine;
        }

        public Event build(String service, String host) {
            return new RequestLogEvent(service, host, this.feed, this.requestLogLine);
        }
    }

    public static class RequestLogEvent
    implements Event {
        final String service;
        final String host;
        final String feed;
        final RequestLogLine request;

        public RequestLogEvent(String service, String host, String feed, RequestLogLine request) {
            this.service = service;
            this.host = host;
            this.request = request;
            this.feed = feed;
        }

        @JsonValue(value=false)
        public Map<String, Object> toMap() {
            return ImmutableMap.of();
        }

        @JsonProperty(value="feed")
        public String getFeed() {
            return this.feed;
        }

        @JsonProperty(value="timestamp")
        public DateTime getCreatedTime() {
            return this.request.getTimestamp();
        }

        @JsonProperty(value="service")
        public String getService() {
            return this.service;
        }

        @JsonProperty(value="host")
        public String getHost() {
            return this.host;
        }

        @JsonProperty(value="query")
        public Query getQuery() {
            return this.request.getQuery();
        }

        @JsonProperty(value="remoteAddr")
        public String getRemoteAddr() {
            return this.request.getRemoteAddr();
        }

        public boolean isSafeToBuffer() {
            return true;
        }
    }
}

