/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.util.Providers;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.HttpPostEmitter;
import com.metamx.http.client.HttpClientConfig;
import com.metamx.http.client.HttpClientInit;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.ManageLifecycle;
import io.druid.server.initialization.HttpEmitterConfig;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;

public class HttpEmitterModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.emitter.http", HttpEmitterConfig.class);
        binder.bind(SSLContext.class).toProvider(Providers.of(null)).in(LazySingleton.class);
    }

    @Provides
    @ManageLifecycle
    @Named(value="http")
    public Emitter getEmitter(Supplier<HttpEmitterConfig> config, @Nullable SSLContext sslContext, Lifecycle lifecycle, ObjectMapper jsonMapper) {
        HttpClientConfig.Builder builder = HttpClientConfig.builder().withNumConnections(1).withReadTimeout(((HttpEmitterConfig)((Object)config.get())).getReadTimeout().toStandardDuration());
        if (sslContext != null) {
            builder.withSslContext(sslContext);
        }
        return new HttpPostEmitter((com.metamx.emitter.core.HttpEmitterConfig)config.get(), HttpClientInit.createClient((HttpClientConfig)builder.build(), (Lifecycle)lifecycle), jsonMapper);
    }
}

