/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.api.client.util.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.druid.client.DruidServer;
import io.druid.client.InventoryView;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/druid/coordinator/v1/tiers")
public class TiersResource {
    private final InventoryView serverInventoryView;

    @Inject
    public TiersResource(InventoryView serverInventoryView) {
        this.serverInventoryView = serverInventoryView;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTiers(@QueryParam(value="simple") String simple) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (simple != null) {
            HashMap metadata = Maps.newHashMap();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                Long currSize;
                Map tierMetadata = (Map)metadata.get(druidServer.getTier());
                if (tierMetadata == null) {
                    tierMetadata = Maps.newHashMap();
                    metadata.put(druidServer.getTier(), tierMetadata);
                }
                tierMetadata.put("currSize", (currSize = (Long)tierMetadata.get("currSize")) == null ? 0L : currSize + druidServer.getCurrSize());
                Long maxSize = (Long)tierMetadata.get("maxSize");
                tierMetadata.put("maxSize", maxSize == null ? 0L : maxSize + druidServer.getMaxSize());
            }
            return builder.entity((Object)metadata).build();
        }
        HashSet tiers = Sets.newHashSet();
        for (DruidServer server : this.serverInventoryView.getInventory()) {
            tiers.add(server.getTier());
        }
        return builder.entity((Object)tiers).build();
    }
}

