/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.server.http.RedirectInfo;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.servlet.DefaultServlet;

public class RedirectServlet
extends DefaultServlet {
    private static final Logger log = new Logger(RedirectServlet.class);
    private final RedirectInfo redirectInfo;

    @Inject
    public RedirectServlet(RedirectInfo redirectInfo) {
        this.redirectInfo = redirectInfo;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response;
        HttpServletRequest request;
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException e) {
            throw new ServletException("non-HTTP request or response");
        }
        if (this.redirectInfo.doLocal()) {
            super.service(request, response);
        } else {
            URL redirectURL = this.redirectInfo.getRedirectURL(request.getQueryString(), request.getRequestURI());
            if (redirectURL == null) {
                response.setStatus(503);
            } else {
                log.info("Forwarding request to [%s]", new Object[]{redirectURL});
                response.setStatus(302);
                response.setHeader("Location", redirectURL.toString());
            }
        }
    }
}

