/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.server.http.RedirectInfo;
import java.io.IOException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RedirectFilter
implements Filter {
    private static final Logger log = new Logger(RedirectFilter.class);
    private final RedirectInfo redirectInfo;

    @Inject
    public RedirectFilter(RedirectInfo redirectInfo) {
        this.redirectInfo = redirectInfo;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response;
        HttpServletRequest request;
        try {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException e) {
            throw new ServletException("non-HTTP request or response");
        }
        if (this.redirectInfo.doLocal()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            URL url = this.redirectInfo.getRedirectURL(request.getQueryString(), request.getRequestURI());
            log.debug("Forwarding request to [%s]", new Object[]{url});
            if (url == null) {
                response.sendError(503);
                return;
            }
            response.setStatus(302);
            response.setHeader("Location", url.toString());
        }
    }

    public void destroy() {
    }
}

