/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.druid.client.DruidDataSource;
import io.druid.client.DruidServer;
import io.druid.client.InventoryView;
import io.druid.client.indexing.IndexingServiceClient;
import io.druid.db.DatabaseSegmentManager;
import io.druid.timeline.DataSegment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.Interval;

@Path(value="/druid/coordinator/v1/datasources")
public class DatasourcesResource {
    private final InventoryView serverInventoryView;
    private final DatabaseSegmentManager databaseSegmentManager;
    private final IndexingServiceClient indexingServiceClient;

    private static Map<String, Object> makeSimpleDatasource(DruidDataSource input) {
        return new ImmutableMap.Builder().put((Object)"name", (Object)input.getName()).put((Object)"properties", input.getProperties()).build();
    }

    @Inject
    public DatasourcesResource(InventoryView serverInventoryView, DatabaseSegmentManager databaseSegmentManager, @Nullable IndexingServiceClient indexingServiceClient) {
        this.serverInventoryView = serverInventoryView;
        this.databaseSegmentManager = databaseSegmentManager;
        this.indexingServiceClient = indexingServiceClient;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getQueryableDataSources(@QueryParam(value="full") String full, @QueryParam(value="simple") String simple) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(this.getDataSources()).build();
        }
        if (simple != null) {
            return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.transform(this.getDataSources(), (Function)new Function<DruidDataSource, Map<String, Object>>(){

                public Map<String, Object> apply(DruidDataSource dataSource) {
                    return DatasourcesResource.makeSimpleDatasource(dataSource);
                }
            }))).build();
        }
        return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.transform(this.getDataSources(), (Function)new Function<DruidDataSource, String>(){

            public String apply(DruidDataSource dataSource) {
                return dataSource.getName();
            }
        }))).build();
    }

    @DELETE
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    public Response deleteDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="kill") String kill, @QueryParam(value="interval") String interval) {
        if (this.indexingServiceClient == null) {
            return Response.ok().entity((Object)ImmutableMap.of((Object)"error", (Object)"no indexing service found")).build();
        }
        if (kill != null && Boolean.valueOf(kill).booleanValue()) {
            try {
                this.indexingServiceClient.killSegments(dataSourceName, new Interval((Object)interval));
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred. Are you sure you have an indexing service?")).build();
            }
        } else if (!this.databaseSegmentManager.removeDatasource(dataSourceName)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/{dataSourceName}")
    @Consumes(value={"application/json"})
    public Response enableDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        if (!this.databaseSegmentManager.enableDatasource(dataSourceName)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    public Response getSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName.toLowerCase());
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Iterables.transform(dataSource.getSegments(), (Function)new Function<DataSegment, Object>(){

            public Object apply(@Nullable DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    public Response getSegmentDataSourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName.toLowerCase());
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (DataSegment segment : dataSource.getSegments()) {
            if (!segment.getIdentifier().equalsIgnoreCase(segmentId)) continue;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    public Response deleteDatasourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        if (!this.databaseSegmentManager.removeSegment(dataSourceName, segmentId)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Consumes(value={"application/json"})
    public Response enableDatasourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        if (!this.databaseSegmentManager.enableSegment(segmentId)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private DruidDataSource getDataSource(final String dataSourceName) {
        Iterable dataSources = Iterables.concat((Iterable[])new Iterable[]{Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, DruidDataSource>(){

            public DruidDataSource apply(DruidServer input) {
                return input.getDataSource(dataSourceName);
            }
        })});
        ArrayList validDataSources = Lists.newArrayList();
        for (DruidDataSource dataSource : dataSources) {
            if (dataSource == null) continue;
            validDataSources.add(dataSource);
        }
        if (validDataSources.isEmpty()) {
            return null;
        }
        HashMap segmentMap = Maps.newHashMap();
        for (DruidDataSource dataSource : validDataSources) {
            if (dataSource == null) continue;
            Set<DataSegment> segments = dataSource.getSegments();
            for (DataSegment segment : segments) {
                segmentMap.put(segment.getIdentifier(), segment);
            }
        }
        return new DruidDataSource(dataSourceName, (Map<String, String>)ImmutableMap.of()).addSegments(segmentMap);
    }

    private Set<DruidDataSource> getDataSources() {
        TreeSet dataSources = Sets.newTreeSet((Comparator)new Comparator<DruidDataSource>(){

            @Override
            public int compare(DruidDataSource druidDataSource, DruidDataSource druidDataSource1) {
                return druidDataSource.getName().compareTo(druidDataSource1.getName());
            }
        });
        dataSources.addAll(Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, Iterable<DruidDataSource>>(){

            public Iterable<DruidDataSource> apply(DruidServer input) {
                return input.getDataSources();
            }
        }))));
        return dataSources;
    }
}

