/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.druid.client.DruidDataSource;
import io.druid.db.DatabaseSegmentManager;
import io.druid.timeline.DataSegment;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/druid/coordinator/v1/db")
public class DBResource {
    private final DatabaseSegmentManager databaseSegmentManager;

    @Inject
    public DBResource(DatabaseSegmentManager databaseSegmentManager) {
        this.databaseSegmentManager = databaseSegmentManager;
    }

    @GET
    @Path(value="/datasources")
    @Produces(value={"application/json"})
    public Response getDatabaseDataSources(@QueryParam(value="full") String full, @QueryParam(value="includeDisabled") String includeDisabled) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (includeDisabled != null) {
            return builder.entity(this.databaseSegmentManager.getAllDatasourceNames()).build();
        }
        if (full != null) {
            return builder.entity(this.databaseSegmentManager.getInventory()).build();
        }
        ArrayList dataSourceNames = Lists.newArrayList((Iterable)Iterables.transform(this.databaseSegmentManager.getInventory(), (Function)new Function<DruidDataSource, String>(){

            public String apply(@Nullable DruidDataSource dataSource) {
                return dataSource.getName();
            }
        }));
        Collections.sort(dataSourceNames);
        return builder.entity((Object)dataSourceNames).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}")
    @Produces(value={"application/json"})
    public Response getDatabaseSegmentDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        DruidDataSource dataSource = this.databaseSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)dataSource).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    public Response getDatabaseSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.databaseSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Iterables.transform(dataSource.getSegments(), (Function)new Function<DataSegment, Object>(){

            public Object apply(@Nullable DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    public Response getDatabaseSegmentDataSourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        DruidDataSource dataSource = this.databaseSegmentManager.getInventoryValue(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (DataSegment segment : dataSource.getSegments()) {
            if (!segment.getIdentifier().equalsIgnoreCase(segmentId)) continue;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

