/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.server.coordinator.rules.DropRule;
import io.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class PeriodDropRule
extends DropRule {
    private final Period period;

    @JsonCreator
    public PeriodDropRule(@JsonProperty(value="period") Period period) {
        this.period = period;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "dropByPeriod";
    }

    @JsonProperty
    public Period getPeriod() {
        return this.period;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        Interval currInterval = new Interval((ReadablePeriod)this.period, (ReadableInstant)referenceTimestamp);
        return currInterval.contains((ReadableInterval)segment.getInterval());
    }
}

