/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.rules;

import com.google.api.client.util.Maps;
import com.google.common.collect.Lists;
import com.google.common.collect.MinMaxPriorityQueue;
import com.metamx.emitter.EmittingLogger;
import io.druid.server.coordinator.BalancerStrategy;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.LoadPeonCallback;
import io.druid.server.coordinator.ReplicationThrottler;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.rules.Rule;
import io.druid.timeline.DataSegment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;

public abstract class LoadRule
implements Rule {
    private static final EmittingLogger log = new EmittingLogger(LoadRule.class);
    private static final String assignedCount = "assignedCount";
    private static final String droppedCount = "droppedCount";

    @Override
    public CoordinatorStats run(DruidCoordinator coordinator, DruidCoordinatorRuntimeParams params, DataSegment segment) {
        CoordinatorStats stats = new CoordinatorStats();
        HashMap loadStatus = Maps.newHashMap();
        int totalReplicantsInCluster = params.getSegmentReplicantLookup().getTotalReplicants(segment.getIdentifier());
        for (Map.Entry<String, Integer> entry : this.getTieredReplicants().entrySet()) {
            String tier = entry.getKey();
            int expectedReplicantsInTier = entry.getValue();
            int totalReplicantsInTier = params.getSegmentReplicantLookup().getTotalReplicants(segment.getIdentifier(), tier);
            int loadedReplicantsInTier = params.getSegmentReplicantLookup().getLoadedReplicants(segment.getIdentifier(), tier);
            MinMaxPriorityQueue<ServerHolder> serverQueue = params.getDruidCluster().getServersByTier(tier);
            if (serverQueue == null) {
                log.makeAlert("Tier[%s] has no servers! Check your cluster configuration!", new Object[]{tier}).emit();
                return stats;
            }
            ArrayList serverHolderList = Lists.newArrayList(serverQueue);
            DateTime referenceTimestamp = params.getBalancerReferenceTimestamp();
            BalancerStrategy strategy = params.getBalancerStrategyFactory().createBalancerStrategy(referenceTimestamp);
            if (params.getAvailableSegments().contains(segment)) {
                CoordinatorStats assignStats = this.assign(params.getReplicationManager(), tier, totalReplicantsInCluster, expectedReplicantsInTier, totalReplicantsInTier, strategy, serverHolderList, segment);
                stats.accumulate(assignStats);
                totalReplicantsInCluster = (int)((long)totalReplicantsInCluster + ((AtomicLong)assignStats.getPerTierStats().get(assignedCount).get((Object)tier)).get());
            }
            loadStatus.put(tier, expectedReplicantsInTier - loadedReplicantsInTier);
        }
        stats.accumulate(this.drop(loadStatus, segment, params));
        return stats;
    }

    private CoordinatorStats assign(final ReplicationThrottler replicationManager, final String tier, int totalReplicantsInCluster, int expectedReplicantsInTier, int totalReplicantsInTier, BalancerStrategy strategy, List<ServerHolder> serverHolderList, final DataSegment segment) {
        CoordinatorStats stats = new CoordinatorStats();
        stats.addToTieredStat(assignedCount, tier, 0L);
        int currReplicantsInTier = totalReplicantsInTier;
        int currTotalReplicantsInCluster = totalReplicantsInCluster;
        while (currReplicantsInTier < expectedReplicantsInTier) {
            boolean replicate;
            boolean bl = replicate = currTotalReplicantsInCluster > 0;
            if (replicate && !replicationManager.canCreateReplicant(tier)) break;
            final ServerHolder holder = strategy.findNewSegmentHomeReplicator(segment, serverHolderList);
            if (holder == null) {
                log.warn("Not enough [%s] servers or node capacity to assign segment[%s]! Expected Replicants[%d]", new Object[]{tier, segment.getIdentifier(), expectedReplicantsInTier});
                break;
            }
            if (replicate) {
                replicationManager.registerReplicantCreation(tier, segment.getIdentifier(), holder.getServer().getHost());
            }
            holder.getPeon().loadSegment(segment, new LoadPeonCallback(){

                @Override
                public void execute() {
                    replicationManager.unregisterReplicantCreation(tier, segment.getIdentifier(), holder.getServer().getHost());
                }
            });
            stats.addToTieredStat(assignedCount, tier, 1L);
            ++currReplicantsInTier;
            ++currTotalReplicantsInCluster;
        }
        return stats;
    }

    private CoordinatorStats drop(Map<String, Integer> loadStatus, final DataSegment segment, DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        if (!params.hasDeletionWaitTimeElapsed()) {
            return stats;
        }
        for (Integer leftToLoad : loadStatus.values()) {
            if (leftToLoad <= 0) continue;
            return stats;
        }
        final ReplicationThrottler replicationManager = params.getReplicationManager();
        Map<String, Integer> replicantsByTier = params.getSegmentReplicantLookup().getClusterTiers(segment.getIdentifier());
        for (Map.Entry<String, Integer> entry : replicantsByTier.entrySet()) {
            final String tier = entry.getKey();
            int loadedNumReplicantsForTier = entry.getValue();
            int expectedNumReplicantsForTier = this.getNumReplicants(tier);
            stats.addToTieredStat(droppedCount, tier, 0L);
            MinMaxPriorityQueue<ServerHolder> serverQueue = params.getDruidCluster().get(tier);
            if (serverQueue == null) {
                log.makeAlert("No holders found for tier[%s]", new Object[]{entry.getKey()}).emit();
                return stats;
            }
            ArrayList droppedServers = Lists.newArrayList();
            while (loadedNumReplicantsForTier > expectedNumReplicantsForTier) {
                final ServerHolder holder = (ServerHolder)serverQueue.pollLast();
                if (holder == null) {
                    log.warn("Wtf, holder was null?  I have no servers serving [%s]?", new Object[]{segment.getIdentifier()});
                    break;
                }
                if (holder.isServingSegment(segment)) {
                    if (expectedNumReplicantsForTier > 0) {
                        if (!replicationManager.canDestroyReplicant(tier)) {
                            serverQueue.add((Object)holder);
                            break;
                        }
                        replicationManager.registerReplicantTermination(tier, segment.getIdentifier(), holder.getServer().getHost());
                    }
                    holder.getPeon().dropSegment(segment, new LoadPeonCallback(){

                        @Override
                        public void execute() {
                            replicationManager.unregisterReplicantTermination(tier, segment.getIdentifier(), holder.getServer().getHost());
                        }
                    });
                    --loadedNumReplicantsForTier;
                    stats.addToTieredStat(droppedCount, tier, 1L);
                }
                droppedServers.add(holder);
            }
            serverQueue.addAll((Collection)droppedServers);
        }
        return stats;
    }

    public abstract Map<String, Integer> getTieredReplicants();

    public abstract int getNumReplicants(String var1);
}

