/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.logger.Logger;
import io.druid.server.coordinator.rules.LoadRule;
import io.druid.timeline.DataSegment;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class IntervalLoadRule
extends LoadRule {
    private static final Logger log = new Logger(IntervalLoadRule.class);
    private final Interval interval;
    private final Map<String, Integer> tieredReplicants;

    @JsonCreator
    public IntervalLoadRule(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="load") Map<String, Integer> tieredReplicants, @JsonProperty(value="replicants") Integer replicants, @JsonProperty(value="tier") String tier) {
        this.interval = interval;
        this.tieredReplicants = tieredReplicants != null ? tieredReplicants : ImmutableMap.of((Object)tier, (Object)replicants);
    }

    @Override
    @JsonProperty
    public String getType() {
        return "loadByInterval";
    }

    @Override
    @JsonProperty
    public Map<String, Integer> getTieredReplicants() {
        return this.tieredReplicants;
    }

    @Override
    public int getNumReplicants(String tier) {
        Integer retVal = this.tieredReplicants.get(tier);
        return retVal == null ? 0 : retVal;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.interval.contains((ReadableInterval)segment.getInterval());
    }
}

