/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.server.coordinator.rules.LoadRule;
import io.druid.timeline.DataSegment;
import java.util.Map;
import org.joda.time.DateTime;

public class ForeverLoadRule
extends LoadRule {
    private final Map<String, Integer> tieredReplicants;

    @JsonCreator
    public ForeverLoadRule(@JsonProperty(value="tieredReplicants") Map<String, Integer> tieredReplicants) {
        this.tieredReplicants = tieredReplicants;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "loadForever";
    }

    @Override
    @JsonProperty
    public Map<String, Integer> getTieredReplicants() {
        return this.tieredReplicants;
    }

    @Override
    public int getNumReplicants(String tier) {
        Integer retVal = this.tieredReplicants.get(tier);
        return retVal == null ? 0 : retVal;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return true;
    }
}

