/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import com.metamx.common.logger.Logger;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.timeline.DataSegment;
import java.util.Set;

public class DruidCoordinatorSegmentInfoLoader
implements DruidCoordinatorHelper {
    private final DruidCoordinator coordinator;
    private static final Logger log = new Logger(DruidCoordinatorSegmentInfoLoader.class);

    public DruidCoordinatorSegmentInfoLoader(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        Set<DataSegment> availableSegments = this.coordinator.getAvailableDataSegments();
        if (log.isDebugEnabled()) {
            log.debug("Available DataSegments", new Object[0]);
            for (DataSegment dataSegment : availableSegments) {
                log.debug("  %s", new Object[]{dataSegment});
            }
        }
        return params.buildFromExisting().withAvailableSegments(availableSegments).build();
    }
}

