/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import com.metamx.emitter.EmittingLogger;
import io.druid.db.DatabaseRuleManager;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.ReplicationThrottler;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.server.coordinator.rules.Rule;
import io.druid.timeline.DataSegment;
import java.util.List;
import org.joda.time.DateTime;

public class DruidCoordinatorRuleRunner
implements DruidCoordinatorHelper {
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinatorRuleRunner.class);
    private final ReplicationThrottler replicatorThrottler;
    private final DruidCoordinator coordinator;

    public DruidCoordinatorRuleRunner(DruidCoordinator coordinator) {
        this(new ReplicationThrottler(coordinator.getDynamicConfigs().getReplicationThrottleLimit(), coordinator.getDynamicConfigs().getReplicantLifetime()), coordinator);
    }

    public DruidCoordinatorRuleRunner(ReplicationThrottler replicatorThrottler, DruidCoordinator coordinator) {
        this.replicatorThrottler = replicatorThrottler;
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        DruidCluster cluster = params.getDruidCluster();
        if (cluster.isEmpty()) {
            log.warn("Uh... I have no servers. Not assigning anything...", new Object[0]);
            return params;
        }
        for (String tier : cluster.getTierNames()) {
            this.replicatorThrottler.updateReplicationState(tier);
            this.replicatorThrottler.updateTerminationState(tier);
        }
        DruidCoordinatorRuntimeParams paramsWithReplicationManager = params.buildFromExisting().withReplicationManager(this.replicatorThrottler).build();
        DateTime now = new DateTime();
        DatabaseRuleManager databaseRuleManager = paramsWithReplicationManager.getDatabaseRuleManager();
        for (DataSegment segment : paramsWithReplicationManager.getAvailableSegments()) {
            List<Rule> rules = databaseRuleManager.getRulesWithDefault(segment.getDataSource());
            boolean foundMatchingRule = false;
            for (Rule rule : rules) {
                if (!rule.appliesTo(segment, now)) continue;
                stats.accumulate(rule.run(this.coordinator, paramsWithReplicationManager, segment));
                foundMatchingRule = true;
                break;
            }
            if (foundMatchingRule) continue;
            log.makeAlert("Unable to find a matching rule for dataSource[%s]", new Object[]{segment.getDataSource()}).addData("segment", (Object)segment.getIdentifier()).emit();
        }
        return paramsWithReplicationManager.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

