/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.client.DruidDataSource;
import io.druid.client.DruidServer;
import io.druid.collections.CountingMap;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.timeline.DataSegment;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class DruidCoordinatorLogger
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorLogger.class);

    private <T extends Number> void emitTieredStats(ServiceEmitter emitter, String formatString, Map<String, T> statMap) {
        if (statMap != null) {
            for (Map.Entry<String, T> entry : statMap.entrySet()) {
                String tier = entry.getKey();
                Number value = (Number)entry.getValue();
                emitter.emit(new ServiceMetricEvent.Builder().build(String.format(formatString, tier), (Number)value.doubleValue()));
            }
        }
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        String dataSource;
        Map unneeded;
        Map dropped;
        DruidCluster cluster = params.getDruidCluster();
        CoordinatorStats stats = params.getCoordinatorStats();
        ServiceEmitter emitter = params.getEmitter();
        Map assigned = (Map)stats.getPerTierStats().get("assignedCount");
        if (assigned != null) {
            for (Map.Entry entry : assigned.entrySet()) {
                log.info("[%s] : Assigned %s segments among %,d servers", new Object[]{entry.getKey(), ((AtomicLong)entry.getValue()).get(), cluster.get((String)entry.getKey()).size()});
            }
        }
        if ((dropped = (Map)stats.getPerTierStats().get("droppedCount")) != null) {
            for (Map.Entry entry : dropped.entrySet()) {
                log.info("[%s] : Dropped %s segments among %,d servers", new Object[]{entry.getKey(), ((AtomicLong)entry.getValue()).get(), cluster.get((String)entry.getKey()).size()});
            }
        }
        this.emitTieredStats(emitter, "coordinator/%s/cost/raw", (Map)stats.getPerTierStats().get("initialCost"));
        this.emitTieredStats(emitter, "coordinator/%s/cost/normalization", (Map)stats.getPerTierStats().get("normalization"));
        this.emitTieredStats(emitter, "coordinator/%s/moved/count", (Map)stats.getPerTierStats().get("movedCount"));
        this.emitTieredStats(emitter, "coordinator/%s/deleted/count", (Map)stats.getPerTierStats().get("deletedCount"));
        Map normalized = (Map)stats.getPerTierStats().get("normalizedInitialCostTimesOneThousand");
        if (normalized != null) {
            this.emitTieredStats(emitter, "coordinator/%s/cost/normalized", Maps.transformEntries((Map)normalized, (Maps.EntryTransformer)new Maps.EntryTransformer<String, AtomicLong, Number>(){

                public Number transformEntry(String key, AtomicLong value) {
                    return value.doubleValue() / 1000.0;
                }
            }));
        }
        if ((unneeded = (Map)stats.getPerTierStats().get("unneededCount")) != null) {
            for (Map.Entry entry : unneeded.entrySet()) {
                log.info("[%s] : Removed %s unneeded segments among %,d servers", new Object[]{entry.getKey(), ((AtomicLong)entry.getValue()).get(), cluster.get((String)entry.getKey()).size()});
            }
        }
        emitter.emit(new ServiceMetricEvent.Builder().build("coordinator/overShadowed/count", (Number)stats.getGlobalStats().get((Object)"overShadowedCount")));
        Map moved = (Map)stats.getPerTierStats().get("movedCount");
        if (moved != null) {
            for (Map.Entry entry : moved.entrySet()) {
                log.info("[%s] : Moved %,d segment(s)", new Object[]{entry.getKey(), ((AtomicLong)entry.getValue()).get()});
            }
        }
        log.info("Load Queues:", new Object[0]);
        for (MinMaxPriorityQueue minMaxPriorityQueue : cluster.getSortedServersByTier()) {
            for (ServerHolder serverHolder : minMaxPriorityQueue) {
                DruidServer druidServer = serverHolder.getServer();
                LoadQueuePeon queuePeon = serverHolder.getPeon();
                log.info("Server[%s, %s, %s] has %,d left to load, %,d left to drop, %,d bytes queued, %,d bytes served.", new Object[]{druidServer.getName(), druidServer.getType(), druidServer.getTier(), queuePeon.getSegmentsToLoad().size(), queuePeon.getSegmentsToDrop().size(), queuePeon.getLoadQueueSize(), druidServer.getCurrSize()});
                if (!log.isDebugEnabled()) continue;
                for (DataSegment segment : queuePeon.getSegmentsToLoad()) {
                    log.debug("Segment to load[%s]", new Object[]{segment});
                }
                for (DataSegment segment : queuePeon.getSegmentsToDrop()) {
                    log.debug("Segment to drop[%s]", new Object[]{segment});
                }
            }
        }
        Set<Map.Entry<String, LoadQueuePeon>> peonEntries = params.getLoadManagementPeons().entrySet();
        for (Map.Entry<String, LoadQueuePeon> entry : peonEntries) {
            String serverName = entry.getKey();
            LoadQueuePeon loadQueuePeon = entry.getValue();
            emitter.emit(new ServiceMetricEvent.Builder().setUser1(serverName).build("coordinator/loadQueue/size", (Number)loadQueuePeon.getLoadQueueSize()));
            emitter.emit(new ServiceMetricEvent.Builder().setUser1(serverName).build("coordinator/loadQueue/failed", (Number)loadQueuePeon.getAndResetFailedAssignCount()));
            emitter.emit(new ServiceMetricEvent.Builder().setUser1(serverName).build("coordinator/loadQueue/count", (Number)loadQueuePeon.getSegmentsToLoad().size()));
            emitter.emit(new ServiceMetricEvent.Builder().setUser1(serverName).build("coordinator/dropQueue/count", (Number)loadQueuePeon.getSegmentsToDrop().size()));
        }
        CountingMap countingMap = new CountingMap();
        CountingMap segmentCounts = new CountingMap();
        for (DruidDataSource druidDataSource : params.getDataSources()) {
            for (DataSegment segment : druidDataSource.getSegments()) {
                countingMap.add((Object)druidDataSource.getName(), segment.getSize());
                segmentCounts.add((Object)druidDataSource.getName(), 1L);
            }
        }
        for (Map.Entry entry : countingMap.snapshot().entrySet()) {
            dataSource = (String)entry.getKey();
            Long size = (Long)entry.getValue();
            emitter.emit(new ServiceMetricEvent.Builder().setUser1(dataSource).build("coordinator/segment/size", (Number)size));
        }
        for (Map.Entry entry : segmentCounts.snapshot().entrySet()) {
            dataSource = (String)entry.getKey();
            Long count = (Long)entry.getValue();
            emitter.emit(new ServiceMetricEvent.Builder().setUser1(dataSource).build("coordinator/segment/count", (Number)count));
        }
        return params;
    }
}

