/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.metamx.common.guava.Comparators;
import com.metamx.common.logger.Logger;
import io.druid.client.DruidDataSource;
import io.druid.client.DruidServer;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.LoadPeonCallback;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import java.util.HashMap;
import java.util.Set;

public class DruidCoordinatorCleanup
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorCleanup.class);
    private final DruidCoordinator coordinator;

    public DruidCoordinatorCleanup(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        Set<DataSegment> availableSegments = params.getAvailableSegments();
        DruidCluster cluster = params.getDruidCluster();
        for (MinMaxPriorityQueue<ServerHolder> serverHolders : cluster.getSortedServersByTier()) {
            for (ServerHolder serverHolder : serverHolders) {
                DruidServer server = serverHolder.getServer();
                for (DruidDataSource dataSource : server.getDataSources()) {
                    for (DataSegment segment : dataSource.getSegments()) {
                        LoadQueuePeon queuePeon;
                        if (availableSegments.contains(segment) || (queuePeon = params.getLoadManagementPeons().get(server.getName())).getSegmentsToDrop().contains(segment)) continue;
                        queuePeon.dropSegment(segment, new LoadPeonCallback(){

                            @Override
                            public void execute() {
                            }
                        });
                        stats.addToTieredStat("unneededCount", server.getTier(), 1L);
                    }
                }
            }
        }
        if (params.hasDeletionWaitTimeElapsed()) {
            HashMap timelines = Maps.newHashMap();
            for (MinMaxPriorityQueue<ServerHolder> serverHolders : cluster.getSortedServersByTier()) {
                for (ServerHolder serverHolder : serverHolders) {
                    DruidServer server = serverHolder.getServer();
                    for (DruidDataSource dataSource : server.getDataSources()) {
                        VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)timelines.get(dataSource.getName());
                        if (timeline == null) {
                            timeline = new VersionedIntervalTimeline(Comparators.comparable());
                            timelines.put(dataSource.getName(), timeline);
                        }
                        for (DataSegment segment : dataSource.getSegments()) {
                            timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
                        }
                    }
                }
            }
            for (VersionedIntervalTimeline timeline : timelines.values()) {
                for (TimelineObjectHolder holder : timeline.findOvershadowed()) {
                    for (DataSegment dataSegment : holder.getObject().payloads()) {
                        this.coordinator.removeSegment(dataSegment);
                        stats.addToGlobalStat("overShadowedCount", 1L);
                    }
                }
            }
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }
}

