/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.metamx.common.logger.Logger;
import io.druid.client.DruidServer;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.timeline.DataSegment;

public class ServerHolder
implements Comparable<ServerHolder> {
    private static final Logger log = new Logger(ServerHolder.class);
    private final DruidServer server;
    private final LoadQueuePeon peon;

    public ServerHolder(DruidServer server, LoadQueuePeon peon) {
        this.server = server;
        this.peon = peon;
    }

    public DruidServer getServer() {
        return this.server;
    }

    public LoadQueuePeon getPeon() {
        return this.peon;
    }

    public Long getMaxSize() {
        return this.server.getMaxSize();
    }

    public Long getCurrServerSize() {
        return this.server.getCurrSize();
    }

    public Long getLoadQueueSize() {
        return this.peon.getLoadQueueSize();
    }

    public Long getSizeUsed() {
        return this.getCurrServerSize() + this.getLoadQueueSize();
    }

    public Double getPercentUsed() {
        return 100.0 * this.getSizeUsed().doubleValue() / (double)this.getMaxSize().longValue();
    }

    public Long getAvailableSize() {
        long maxSize = this.getMaxSize();
        long sizeUsed = this.getSizeUsed();
        long availableSize = maxSize - sizeUsed;
        log.debug("Server[%s], MaxSize[%,d], CurrSize[%,d], QueueSize[%,d], SizeUsed[%,d], AvailableSize[%,d]", new Object[]{this.server.getName(), maxSize, this.getCurrServerSize(), this.getLoadQueueSize(), sizeUsed, availableSize});
        return availableSize;
    }

    public boolean isServingSegment(DataSegment segment) {
        return this.server.getSegment(segment.getIdentifier()) != null;
    }

    public boolean isLoadingSegment(DataSegment segment) {
        return this.peon.getSegmentsToLoad().contains(segment);
    }

    @Override
    public int compareTo(ServerHolder serverHolder) {
        return this.getAvailableSize().compareTo(serverHolder.getAvailableSize());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerHolder that = (ServerHolder)o;
        if (this.peon != null ? !this.peon.equals(that.peon) : that.peon != null) {
            return false;
        }
        return !(this.server != null ? !this.server.equals(that.server) : that.server != null);
    }

    public int hashCode() {
        int result = this.server != null ? this.server.hashCode() : 0;
        result = 31 * result + (this.peon != null ? this.peon.hashCode() : 0);
        return result;
    }
}

