/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Table;
import io.druid.client.DruidServer;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.ServerHolder;
import io.druid.timeline.DataSegment;
import java.util.Map;

public class SegmentReplicantLookup {
    private final Table<String, String, Integer> segmentsInCluster;
    private final Table<String, String, Integer> loadingSegments;

    public static SegmentReplicantLookup make(DruidCluster cluster) {
        HashBasedTable segmentsInCluster = HashBasedTable.create();
        HashBasedTable loadingSegments = HashBasedTable.create();
        for (MinMaxPriorityQueue<ServerHolder> serversByType : cluster.getSortedServersByTier()) {
            for (ServerHolder serverHolder : serversByType) {
                Integer numReplicants;
                DruidServer server = serverHolder.getServer();
                for (DataSegment segment : server.getSegments().values()) {
                    numReplicants = (Integer)segmentsInCluster.get((Object)segment.getIdentifier(), (Object)server.getTier());
                    if (numReplicants == null) {
                        numReplicants = 0;
                    }
                    numReplicants = numReplicants + 1;
                    segmentsInCluster.put((Object)segment.getIdentifier(), (Object)server.getTier(), (Object)numReplicants);
                }
                for (DataSegment segment : serverHolder.getPeon().getSegmentsToLoad()) {
                    numReplicants = (Integer)loadingSegments.get((Object)segment.getIdentifier(), (Object)server.getTier());
                    if (numReplicants == null) {
                        numReplicants = 0;
                    }
                    numReplicants = numReplicants + 1;
                    loadingSegments.put((Object)segment.getIdentifier(), (Object)server.getTier(), (Object)numReplicants);
                }
            }
        }
        return new SegmentReplicantLookup((Table<String, String, Integer>)segmentsInCluster, (Table<String, String, Integer>)loadingSegments);
    }

    private SegmentReplicantLookup(Table<String, String, Integer> segmentsInCluster, Table<String, String, Integer> loadingSegments) {
        this.segmentsInCluster = segmentsInCluster;
        this.loadingSegments = loadingSegments;
    }

    public Map<String, Integer> getClusterTiers(String segmentId) {
        Map retVal = this.segmentsInCluster.row((Object)segmentId);
        return retVal == null ? Maps.newHashMap() : retVal;
    }

    public Map<String, Integer> getLoadingTiers(String segmentId) {
        Map retVal = this.loadingSegments.row((Object)segmentId);
        return retVal == null ? Maps.newHashMap() : retVal;
    }

    public int getLoadedReplicants(String segmentId) {
        Map allTiers = this.segmentsInCluster.row((Object)segmentId);
        int retVal = 0;
        for (Integer replicants : allTiers.values()) {
            retVal += replicants.intValue();
        }
        return retVal;
    }

    public int getLoadedReplicants(String segmentId, String tier) {
        Integer retVal = (Integer)this.segmentsInCluster.get((Object)segmentId, (Object)tier);
        return retVal == null ? 0 : retVal;
    }

    public int getLoadingReplicants(String segmentId, String tier) {
        Integer retVal = (Integer)this.loadingSegments.get((Object)segmentId, (Object)tier);
        return retVal == null ? 0 : retVal;
    }

    public int getLoadingReplicants(String segmentId) {
        Map allTiers = this.loadingSegments.row((Object)segmentId);
        int retVal = 0;
        for (Integer replicants : allTiers.values()) {
            retVal += replicants.intValue();
        }
        return retVal;
    }

    public int getTotalReplicants(String segmentId) {
        return this.getLoadedReplicants(segmentId) + this.getLoadingReplicants(segmentId);
    }

    public int getTotalReplicants(String segmentId, String tier) {
        return this.getLoadedReplicants(segmentId, tier) + this.getLoadingReplicants(segmentId, tier);
    }
}

