/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import com.metamx.common.guava.Comparators;
import com.metamx.emitter.EmittingLogger;
import io.druid.server.coordination.DataSegmentChangeRequest;
import io.druid.server.coordination.SegmentChangeRequestDrop;
import io.druid.server.coordination.SegmentChangeRequestLoad;
import io.druid.server.coordination.SegmentChangeRequestNoop;
import io.druid.server.coordinator.DruidCoordinatorConfig;
import io.druid.server.coordinator.LoadPeonCallback;
import io.druid.timeline.DataSegment;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.Stat;

public class LoadQueuePeon {
    private static final EmittingLogger log = new EmittingLogger(LoadQueuePeon.class);
    private static final int DROP = 0;
    private static final int LOAD = 1;
    private static Comparator<SegmentHolder> segmentHolderComparator = new Comparator<SegmentHolder>(){
        private Comparator<DataSegment> comparator = Comparators.inverse((Comparator)DataSegment.bucketMonthComparator());

        @Override
        public int compare(SegmentHolder lhs, SegmentHolder rhs) {
            return this.comparator.compare(lhs.getSegment(), rhs.getSegment());
        }
    };
    private final CuratorFramework curator;
    private final String basePath;
    private final ObjectMapper jsonMapper;
    private final ScheduledExecutorService zkWritingExecutor;
    private final DruidCoordinatorConfig config;
    private final AtomicLong queuedSize = new AtomicLong(0L);
    private final AtomicInteger failedAssignCount = new AtomicInteger(0);
    private final ConcurrentSkipListSet<SegmentHolder> segmentsToLoad = new ConcurrentSkipListSet<SegmentHolder>(segmentHolderComparator);
    private final ConcurrentSkipListSet<SegmentHolder> segmentsToDrop = new ConcurrentSkipListSet<SegmentHolder>(segmentHolderComparator);
    private final Object lock = new Object();
    private volatile SegmentHolder currentlyLoading = null;

    LoadQueuePeon(CuratorFramework curator, String basePath, ObjectMapper jsonMapper, ScheduledExecutorService zkWritingExecutor, DruidCoordinatorConfig config) {
        this.curator = curator;
        this.basePath = basePath;
        this.jsonMapper = jsonMapper;
        this.zkWritingExecutor = zkWritingExecutor;
        this.config = config;
    }

    @JsonProperty
    public Set<DataSegment> getSegmentsToLoad() {
        return new ConcurrentSkipListSet<DataSegment>(Collections2.transform(this.segmentsToLoad, (Function)new Function<SegmentHolder, DataSegment>(){

            public DataSegment apply(SegmentHolder input) {
                return input.getSegment();
            }
        }));
    }

    @JsonProperty
    public Set<DataSegment> getSegmentsToDrop() {
        return new ConcurrentSkipListSet<DataSegment>(Collections2.transform(this.segmentsToDrop, (Function)new Function<SegmentHolder, DataSegment>(){

            public DataSegment apply(SegmentHolder input) {
                return input.getSegment();
            }
        }));
    }

    public long getLoadQueueSize() {
        return this.queuedSize.get();
    }

    public int getAndResetFailedAssignCount() {
        return this.failedAssignCount.getAndSet(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSegment(DataSegment segment, LoadPeonCallback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentlyLoading != null && this.currentlyLoading.getSegmentIdentifier().equals(segment.getIdentifier())) {
                if (callback != null) {
                    this.currentlyLoading.addCallback(callback);
                }
                return;
            }
        }
        SegmentHolder holder = new SegmentHolder(segment, 1, Arrays.asList(callback));
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.segmentsToLoad.contains(holder)) {
                if (callback != null) {
                    this.currentlyLoading.addCallback(callback);
                }
                return;
            }
        }
        log.info("Asking server peon[%s] to load segment[%s]", new Object[]{this.basePath, segment});
        this.queuedSize.addAndGet(segment.getSize());
        this.segmentsToLoad.add(holder);
        this.doNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSegment(DataSegment segment, LoadPeonCallback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentlyLoading != null && this.currentlyLoading.getSegmentIdentifier().equals(segment.getIdentifier())) {
                if (callback != null) {
                    this.currentlyLoading.addCallback(callback);
                }
                return;
            }
        }
        SegmentHolder holder = new SegmentHolder(segment, 0, Arrays.asList(callback));
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.segmentsToDrop.contains(holder)) {
                if (callback != null) {
                    this.currentlyLoading.addCallback(callback);
                }
                return;
            }
        }
        log.info("Asking server peon[%s] to drop segment[%s]", new Object[]{this.basePath, segment});
        this.segmentsToDrop.add(holder);
        this.doNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNext() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentlyLoading == null) {
                if (!this.segmentsToDrop.isEmpty()) {
                    this.currentlyLoading = this.segmentsToDrop.first();
                    log.info("Server[%s] dropping [%s]", new Object[]{this.basePath, this.currentlyLoading});
                } else if (!this.segmentsToLoad.isEmpty()) {
                    this.currentlyLoading = this.segmentsToLoad.first();
                    log.info("Server[%s] loading [%s]", new Object[]{this.basePath, this.currentlyLoading});
                } else {
                    return;
                }
                this.zkWritingExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = LoadQueuePeon.this.lock;
                        synchronized (object) {
                            try {
                                if (LoadQueuePeon.this.currentlyLoading == null) {
                                    log.makeAlert("Crazy race condition! server[%s]", new Object[]{LoadQueuePeon.this.basePath}).emit();
                                    LoadQueuePeon.this.actionCompleted();
                                    LoadQueuePeon.this.doNext();
                                    return;
                                }
                                log.info("Server[%s] adding segment[%s]", new Object[]{LoadQueuePeon.this.basePath, LoadQueuePeon.this.currentlyLoading.getSegmentIdentifier()});
                                final String path = ZKPaths.makePath((String)LoadQueuePeon.this.basePath, (String)LoadQueuePeon.this.currentlyLoading.getSegmentIdentifier());
                                byte[] payload = LoadQueuePeon.this.jsonMapper.writeValueAsBytes((Object)LoadQueuePeon.this.currentlyLoading.getChangeRequest());
                                ((ACLBackgroundPathAndBytesable)LoadQueuePeon.this.curator.create().withMode(CreateMode.EPHEMERAL)).forPath(path, payload);
                                LoadQueuePeon.this.zkWritingExecutor.schedule(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            if (LoadQueuePeon.this.curator.checkExists().forPath(path) != null) {
                                                LoadQueuePeon.this.failAssign((Exception)new ISE("%s was never removed! Failing this assign!", new Object[]{path}));
                                            }
                                        }
                                        catch (Exception e) {
                                            LoadQueuePeon.this.failAssign(e);
                                        }
                                    }
                                }, LoadQueuePeon.this.config.getLoadTimeoutDelay().getMillis(), TimeUnit.MILLISECONDS);
                                Stat stat = (Stat)((BackgroundPathable)LoadQueuePeon.this.curator.checkExists().usingWatcher(new CuratorWatcher(){

                                    public void process(WatchedEvent watchedEvent) throws Exception {
                                        switch (watchedEvent.getType()) {
                                            case NodeDeleted: {
                                                LoadQueuePeon.this.entryRemoved(watchedEvent.getPath());
                                            }
                                        }
                                    }
                                })).forPath(path);
                                if (stat == null) {
                                    byte[] noopPayload = LoadQueuePeon.this.jsonMapper.writeValueAsBytes((Object)new SegmentChangeRequestNoop());
                                    ((ACLBackgroundPathAndBytesable)LoadQueuePeon.this.curator.create().withMode(CreateMode.EPHEMERAL)).forPath(path, noopPayload);
                                    LoadQueuePeon.this.entryRemoved(path);
                                }
                            }
                            catch (Exception e) {
                                LoadQueuePeon.this.failAssign(e);
                            }
                        }
                    }
                });
            } else {
                log.info("Server[%s] skipping doNext() because something is currently loading[%s].", new Object[]{this.basePath, this.currentlyLoading});
            }
        }
    }

    private void actionCompleted() {
        if (this.currentlyLoading != null) {
            switch (this.currentlyLoading.getType()) {
                case 1: {
                    this.segmentsToLoad.remove(this.currentlyLoading);
                    this.queuedSize.addAndGet(-this.currentlyLoading.getSegmentSize());
                    break;
                }
                case 0: {
                    this.segmentsToDrop.remove(this.currentlyLoading);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.currentlyLoading.executeCallbacks();
            this.currentlyLoading = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentlyLoading != null) {
                this.currentlyLoading.executeCallbacks();
                this.currentlyLoading = null;
            }
            if (!this.segmentsToDrop.isEmpty()) {
                for (SegmentHolder holder : this.segmentsToDrop) {
                    holder.executeCallbacks();
                }
            }
            this.segmentsToDrop.clear();
            if (!this.segmentsToLoad.isEmpty()) {
                for (SegmentHolder holder : this.segmentsToLoad) {
                    holder.executeCallbacks();
                }
            }
            this.segmentsToLoad.clear();
            this.queuedSize.set(0L);
            this.failedAssignCount.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entryRemoved(String path) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentlyLoading == null) {
                log.warn("Server[%s] an entry[%s] was removed even though it wasn't loading!?", new Object[]{this.basePath, path});
                return;
            }
            if (!ZKPaths.getNodeFromPath((String)path).equals(this.currentlyLoading.getSegmentIdentifier())) {
                log.warn("Server[%s] entry [%s] was removed even though it's not what is currently loading[%s]", new Object[]{this.basePath, path, this.currentlyLoading});
                return;
            }
            this.actionCompleted();
            log.info("Server[%s] done processing [%s]", new Object[]{this.basePath, path});
        }
        this.doNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failAssign(Exception e) {
        Object object = this.lock;
        synchronized (object) {
            log.error((Throwable)e, "Server[%s], throwable caught when submitting [%s].", new Object[]{this.basePath, this.currentlyLoading});
            this.failedAssignCount.getAndIncrement();
            this.actionCompleted();
            this.doNext();
        }
    }

    private class SegmentHolder {
        private final DataSegment segment;
        private final DataSegmentChangeRequest changeRequest;
        private final int type;
        private final List<LoadPeonCallback> callbacks = Lists.newArrayList();

        private SegmentHolder(DataSegment segment, int type, Collection<LoadPeonCallback> callbacks) {
            this.segment = segment;
            this.type = type;
            this.changeRequest = type == 1 ? new SegmentChangeRequestLoad(segment) : new SegmentChangeRequestDrop(segment);
            this.callbacks.addAll(callbacks);
        }

        public DataSegment getSegment() {
            return this.segment;
        }

        public int getType() {
            return this.type;
        }

        public String getSegmentIdentifier() {
            return this.segment.getIdentifier();
        }

        public long getSegmentSize() {
            return this.segment.getSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallbacks(Collection<LoadPeonCallback> newCallbacks) {
            List<LoadPeonCallback> list = this.callbacks;
            synchronized (list) {
                this.callbacks.addAll(newCallbacks);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallback(LoadPeonCallback newCallback) {
            List<LoadPeonCallback> list = this.callbacks;
            synchronized (list) {
                this.callbacks.add(newCallback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeCallbacks() {
            List<LoadPeonCallback> list = this.callbacks;
            synchronized (list) {
                for (LoadPeonCallback callback : this.callbacks) {
                    if (callback == null) continue;
                    callback.execute();
                }
                this.callbacks.clear();
            }
        }

        public DataSegmentChangeRequest getChangeRequest() {
            return this.changeRequest;
        }

        public String toString() {
            return this.changeRequest.toString();
        }
    }
}

