/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CoordinatorDynamicConfig {
    public static final String CONFIG_KEY = "coordinator.config";
    private final long millisToWaitBeforeDeleting;
    private final long mergeBytesLimit;
    private final int mergeSegmentsLimit;
    private final int maxSegmentsToMove;
    private final int replicantLifetime;
    private final int replicationThrottleLimit;
    private final boolean emitBalancingStats;

    @JsonCreator
    public CoordinatorDynamicConfig(@JsonProperty(value="millisToWaitBeforeDeleting") long millisToWaitBeforeDeleting, @JsonProperty(value="mergeBytesLimit") long mergeBytesLimit, @JsonProperty(value="mergeSegmentsLimit") int mergeSegmentsLimit, @JsonProperty(value="maxSegmentsToMove") int maxSegmentsToMove, @JsonProperty(value="replicantLifetime") int replicantLifetime, @JsonProperty(value="replicationThrottleLimit") int replicationThrottleLimit, @JsonProperty(value="emitBalancingStats") boolean emitBalancingStats) {
        this.maxSegmentsToMove = maxSegmentsToMove;
        this.millisToWaitBeforeDeleting = millisToWaitBeforeDeleting;
        this.mergeSegmentsLimit = mergeSegmentsLimit;
        this.mergeBytesLimit = mergeBytesLimit;
        this.replicantLifetime = replicantLifetime;
        this.replicationThrottleLimit = replicationThrottleLimit;
        this.emitBalancingStats = emitBalancingStats;
    }

    @JsonProperty
    public long getMillisToWaitBeforeDeleting() {
        return this.millisToWaitBeforeDeleting;
    }

    @JsonProperty
    public long getMergeBytesLimit() {
        return this.mergeBytesLimit;
    }

    @JsonProperty
    public boolean emitBalancingStats() {
        return this.emitBalancingStats;
    }

    @JsonProperty
    public int getMergeSegmentsLimit() {
        return this.mergeSegmentsLimit;
    }

    @JsonProperty
    public int getMaxSegmentsToMove() {
        return this.maxSegmentsToMove;
    }

    @JsonProperty
    public int getReplicantLifetime() {
        return this.replicantLifetime;
    }

    @JsonProperty
    public int getReplicationThrottleLimit() {
        return this.replicationThrottleLimit;
    }

    public static class Builder {
        private long millisToWaitBeforeDeleting;
        private long mergeBytesLimit;
        private int mergeSegmentsLimit;
        private int maxSegmentsToMove;
        private int replicantLifetime;
        private int replicationThrottleLimit;
        private boolean emitBalancingStats;

        public Builder() {
            this(900000L, 100000000L, Integer.MAX_VALUE, 5, 15, 10, false);
        }

        private Builder(long millisToWaitBeforeDeleting, long mergeBytesLimit, int mergeSegmentsLimit, int maxSegmentsToMove, int replicantLifetime, int replicationThrottleLimit, boolean emitBalancingStats) {
            this.millisToWaitBeforeDeleting = millisToWaitBeforeDeleting;
            this.mergeBytesLimit = mergeBytesLimit;
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            this.maxSegmentsToMove = maxSegmentsToMove;
            this.replicantLifetime = replicantLifetime;
            this.replicationThrottleLimit = replicationThrottleLimit;
            this.emitBalancingStats = emitBalancingStats;
        }

        public Builder withMillisToWaitBeforeDeleting(long millisToWaitBeforeDeleting) {
            this.millisToWaitBeforeDeleting = millisToWaitBeforeDeleting;
            return this;
        }

        public Builder withMergeBytesLimit(long mergeBytesLimit) {
            this.mergeBytesLimit = mergeBytesLimit;
            return this;
        }

        public Builder withMergeSegmentsLimit(int mergeSegmentsLimit) {
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            return this;
        }

        public Builder withMaxSegmentsToMove(int maxSegmentsToMove) {
            this.maxSegmentsToMove = maxSegmentsToMove;
            return this;
        }

        public Builder withReplicantLifetime(int replicantLifetime) {
            this.replicantLifetime = replicantLifetime;
            return this;
        }

        public Builder withReplicationThrottleLimit(int replicationThrottleLimit) {
            this.replicationThrottleLimit = replicationThrottleLimit;
            return this;
        }

        public CoordinatorDynamicConfig build() {
            return new CoordinatorDynamicConfig(this.millisToWaitBeforeDeleting, this.mergeBytesLimit, this.mergeSegmentsLimit, this.maxSegmentsToMove, this.replicantLifetime, this.replicationThrottleLimit, this.emitBalancingStats);
        }
    }
}

