/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.metamx.emitter.EmittingLogger;
import io.druid.segment.loading.SegmentLoaderConfig;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.server.coordination.BaseZkCoordinator;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.server.coordination.DataSegmentChangeCallback;
import io.druid.server.coordination.DataSegmentChangeHandler;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.coordination.ServerManager;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.curator.framework.CuratorFramework;

public class ZkCoordinator
extends BaseZkCoordinator {
    private static final EmittingLogger log = new EmittingLogger(ZkCoordinator.class);
    private final ObjectMapper jsonMapper;
    private final SegmentLoaderConfig config;
    private final DataSegmentAnnouncer announcer;
    private final ServerManager serverManager;

    @Inject
    public ZkCoordinator(ObjectMapper jsonMapper, SegmentLoaderConfig config, ZkPathsConfig zkPaths, DruidServerMetadata me, DataSegmentAnnouncer announcer, CuratorFramework curator, ServerManager serverManager) {
        super(jsonMapper, zkPaths, me, curator);
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.announcer = announcer;
        this.serverManager = serverManager;
    }

    @Override
    public void loadLocalCache() {
        final long start = System.currentTimeMillis();
        File baseDir = this.config.getInfoDir();
        if (!baseDir.exists() && !this.config.getInfoDir().mkdirs()) {
            return;
        }
        ArrayList cachedSegments = Lists.newArrayList();
        for (File file : baseDir.listFiles()) {
            log.info("Loading segment cache file [%s]", new Object[]{file});
            try {
                DataSegment segment = (DataSegment)this.jsonMapper.readValue(file, DataSegment.class);
                if (this.serverManager.isSegmentCached(segment)) {
                    cachedSegments.add(segment);
                    continue;
                }
                log.warn("Unable to find cache file for %s. Deleting lookup entry", new Object[]{segment.getIdentifier()});
                File segmentInfoCacheFile = new File(this.config.getInfoDir(), segment.getIdentifier());
                if (segmentInfoCacheFile.delete()) continue;
                log.warn("Unable to delete segmentInfoCacheFile[%s]", new Object[]{segmentInfoCacheFile});
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Failed to load segment from segmentInfo file", new Object[0]).addData("file", (Object)file).emit();
            }
        }
        this.addSegments(cachedSegments, new DataSegmentChangeCallback(){

            @Override
            public void execute() {
                log.info("Cache load took %,d ms", new Object[]{System.currentTimeMillis() - start});
            }
        });
    }

    @Override
    public DataSegmentChangeHandler getDataSegmentChangeHandler() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSegment(DataSegment segment, DataSegmentChangeCallback callback) {
        block12: {
            try {
                boolean loaded;
                log.info("Loading segment %s", new Object[]{segment.getIdentifier()});
                try {
                    loaded = this.serverManager.loadSegment(segment);
                }
                catch (Exception e) {
                    this.removeSegment(segment, callback);
                    throw new SegmentLoadingException((Throwable)e, "Exception loading segment[%s]", new Object[]{segment.getIdentifier()});
                }
                if (!loaded) break block12;
                File segmentInfoCacheFile = new File(this.config.getInfoDir(), segment.getIdentifier());
                if (!segmentInfoCacheFile.exists()) {
                    try {
                        this.jsonMapper.writeValue(segmentInfoCacheFile, (Object)segment);
                    }
                    catch (IOException e) {
                        this.removeSegment(segment, callback);
                        throw new SegmentLoadingException((Throwable)e, "Failed to write to disk segment info cache file[%s]", new Object[]{segmentInfoCacheFile});
                    }
                }
                try {
                    this.announcer.announceSegment(segment);
                }
                catch (IOException e) {
                    throw new SegmentLoadingException((Throwable)e, "Failed to announce segment[%s]", new Object[]{segment.getIdentifier()});
                }
            }
            catch (SegmentLoadingException e) {
                log.makeAlert((Throwable)e, "Failed to load segment for dataSource", new Object[0]).addData("segment", (Object)segment).emit();
            }
            finally {
                callback.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSegments(Iterable<DataSegment> segments, DataSegmentChangeCallback callback) {
        try {
            ArrayList segmentFailures = Lists.newArrayList();
            ArrayList validSegments = Lists.newArrayList();
            for (DataSegment segment : segments) {
                boolean loaded;
                log.info("Loading segment %s", new Object[]{segment.getIdentifier()});
                try {
                    loaded = this.serverManager.loadSegment(segment);
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Exception loading segment[%s]", new Object[]{segment.getIdentifier()});
                    this.removeSegment(segment, callback);
                    segmentFailures.add(segment.getIdentifier());
                    continue;
                }
                if (!loaded) continue;
                File segmentInfoCacheFile = new File(this.config.getInfoDir(), segment.getIdentifier());
                if (!segmentInfoCacheFile.exists()) {
                    try {
                        this.jsonMapper.writeValue(segmentInfoCacheFile, (Object)segment);
                    }
                    catch (IOException e) {
                        log.error((Throwable)e, "Failed to write to disk segment info cache file[%s]", new Object[]{segmentInfoCacheFile});
                        this.removeSegment(segment, callback);
                        segmentFailures.add(segment.getIdentifier());
                        continue;
                    }
                }
                validSegments.add(segment);
            }
            try {
                this.announcer.announceSegments(validSegments);
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Failed to announce segments[%s]", new Object[]{segments});
            }
            if (!segmentFailures.isEmpty()) {
                for (String segmentFailure : segmentFailures) {
                    log.error("%s failed to load", new Object[]{segmentFailure});
                }
                throw new SegmentLoadingException("%,d errors seen while loading segments", new Object[]{segmentFailures.size()});
            }
        }
        catch (SegmentLoadingException e) {
            log.makeAlert((Throwable)e, "Failed to load segments for dataSource", new Object[0]).addData("segments", segments).emit();
        }
        finally {
            callback.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSegment(DataSegment segment, DataSegmentChangeCallback callback) {
        try {
            this.serverManager.dropSegment(segment);
            File segmentInfoCacheFile = new File(this.config.getInfoDir(), segment.getIdentifier());
            if (!segmentInfoCacheFile.delete()) {
                log.warn("Unable to delete segmentInfoCacheFile[%s]", new Object[]{segmentInfoCacheFile});
            }
            this.announcer.unannounceSegment(segment);
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "Failed to remove segment", new Object[0]).addData("segment", (Object)segment).emit();
        }
        finally {
            callback.execute();
        }
    }
}

