/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.curator.announcement.Announcer;
import io.druid.server.coordination.AbstractDataSegmentAnnouncer;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import org.apache.curator.utils.ZKPaths;

public class SingleDataSegmentAnnouncer
extends AbstractDataSegmentAnnouncer {
    private static final Logger log = new Logger(SingleDataSegmentAnnouncer.class);
    private final Announcer announcer;
    private final ObjectMapper jsonMapper;
    private final String servedSegmentsLocation;

    @Inject
    public SingleDataSegmentAnnouncer(DruidServerMetadata server, ZkPathsConfig config, Announcer announcer, ObjectMapper jsonMapper) {
        super(server, config, announcer, jsonMapper);
        this.announcer = announcer;
        this.jsonMapper = jsonMapper;
        this.servedSegmentsLocation = ZKPaths.makePath((String)config.getServedSegmentsPath(), (String)server.getName());
    }

    @Override
    public void announceSegment(DataSegment segment) throws IOException {
        String path = this.makeServedSegmentPath(segment);
        log.info("Announcing segment[%s] to path[%s]", new Object[]{segment.getIdentifier(), path});
        this.announcer.announce(path, this.jsonMapper.writeValueAsBytes((Object)segment));
    }

    @Override
    public void unannounceSegment(DataSegment segment) throws IOException {
        String path = this.makeServedSegmentPath(segment);
        log.info("Unannouncing segment[%s] at path[%s]", new Object[]{segment.getIdentifier(), path});
        this.announcer.unannounce(path);
    }

    @Override
    public void announceSegments(Iterable<DataSegment> segments) throws IOException {
        for (DataSegment segment : segments) {
            this.announceSegment(segment);
        }
    }

    @Override
    public void unannounceSegments(Iterable<DataSegment> segments) throws IOException {
        for (DataSegment segment : segments) {
            this.unannounceSegment(segment);
        }
    }

    private String makeServedSegmentPath(DataSegment segment) {
        return ZKPaths.makePath((String)this.servedSegmentsLocation, (String)segment.getIdentifier());
    }
}

