/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.CountingMap;
import io.druid.guice.annotations.Processing;
import io.druid.query.BySegmentQueryRunner;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.MetricsEmittingQueryRunner;
import io.druid.query.NoopQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChest;
import io.druid.query.ReferenceCountingSegmentQueryRunner;
import io.druid.query.SegmentDescriptor;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.spec.SpecificSegmentQueryRunner;
import io.druid.query.spec.SpecificSegmentSpec;
import io.druid.segment.ReferenceCountingSegment;
import io.druid.segment.Segment;
import io.druid.segment.loading.SegmentLoader;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.PartitionHolder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final Object lock = new Object();
    private final SegmentLoader segmentLoader;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final ExecutorService exec;
    private final Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> dataSources;
    private final CountingMap<String> dataSourceSizes = new CountingMap();
    private final CountingMap<String> dataSourceCounts = new CountingMap();

    @Inject
    public ServerManager(SegmentLoader segmentLoader, QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, @Processing ExecutorService exec) {
        this.segmentLoader = segmentLoader;
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.exec = exec;
        this.dataSources = new HashMap<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getDataSourceSizes() {
        CountingMap<String> countingMap = this.dataSourceSizes;
        synchronized (countingMap) {
            return this.dataSourceSizes.snapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getDataSourceCounts() {
        CountingMap<String> countingMap = this.dataSourceCounts;
        synchronized (countingMap) {
            return this.dataSourceCounts.snapshot();
        }
    }

    public boolean isSegmentCached(DataSegment segment) throws SegmentLoadingException {
        return this.segmentLoader.isSegmentLoaded(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSegment(DataSegment segment) throws SegmentLoadingException {
        Segment adapter;
        try {
            adapter = this.segmentLoader.getSegment(segment);
        }
        catch (SegmentLoadingException e) {
            try {
                this.segmentLoader.cleanup(segment);
            }
            catch (SegmentLoadingException e1) {
                // empty catch block
            }
            throw e;
        }
        if (adapter == null) {
            throw new SegmentLoadingException("Null adapter from loadSpec[%s]", new Object[]{segment.getLoadSpec()});
        }
        Object object = this.lock;
        synchronized (object) {
            PartitionHolder entry;
            String dataSource = segment.getDataSource();
            VersionedIntervalTimeline loadedIntervals = this.dataSources.get(dataSource);
            if (loadedIntervals == null) {
                loadedIntervals = new VersionedIntervalTimeline((Comparator)Ordering.natural());
                this.dataSources.put(dataSource, (VersionedIntervalTimeline<String, ReferenceCountingSegment>)loadedIntervals);
            }
            if ((entry = loadedIntervals.findEntry(segment.getInterval(), (Object)segment.getVersion())) != null && entry.getChunk(segment.getShardSpec().getPartitionNum()) != null) {
                log.warn("Told to load a adapter for a segment[%s] that already exists", new Object[]{segment.getIdentifier()});
                return false;
            }
            loadedIntervals.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)new ReferenceCountingSegment(adapter)));
            CountingMap<String> countingMap = this.dataSourceSizes;
            synchronized (countingMap) {
                this.dataSourceSizes.add((Object)dataSource, segment.getSize());
            }
            countingMap = this.dataSourceCounts;
            synchronized (countingMap) {
                this.dataSourceCounts.add((Object)dataSource, 1L);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSegment(DataSegment segment) throws SegmentLoadingException {
        String dataSource = segment.getDataSource();
        Object object = this.lock;
        synchronized (object) {
            ReferenceCountingSegment oldQueryable;
            VersionedIntervalTimeline<String, ReferenceCountingSegment> loadedIntervals = this.dataSources.get(dataSource);
            if (loadedIntervals == null) {
                log.info("Told to delete a queryable for a dataSource[%s] that doesn't exist.", new Object[]{dataSource});
                return;
            }
            PartitionChunk removed = loadedIntervals.remove(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)null));
            ReferenceCountingSegment referenceCountingSegment = oldQueryable = removed == null ? null : (ReferenceCountingSegment)removed.getObject();
            if (oldQueryable != null) {
                CountingMap<String> countingMap = this.dataSourceSizes;
                synchronized (countingMap) {
                    this.dataSourceSizes.add((Object)dataSource, -segment.getSize());
                }
                countingMap = this.dataSourceCounts;
                synchronized (countingMap) {
                    this.dataSourceCounts.add((Object)dataSource, -1L);
                }
                try {
                    log.info("Attempting to close segment %s", new Object[]{segment.getIdentifier()});
                    oldQueryable.close();
                }
                catch (IOException e) {
                    log.makeAlert((Throwable)e, "Exception closing segment", new Object[0]).addData("dataSource", (Object)dataSource).addData("segmentId", (Object)segment.getIdentifier()).emit();
                }
            } else {
                log.info("Told to delete a queryable on dataSource[%s] for interval[%s] and version [%s] that I don't have.", new Object[]{dataSource, segment.getInterval(), segment.getVersion()});
            }
        }
        this.segmentLoader.cleanup(segment);
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", new Object[]{query.getClass()});
        }
        final QueryToolChest toolChest = factory.getToolchest();
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.dataSources.get(query.getDataSource());
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        FunctionalIterable adapters = FunctionalIterable.create(intervals).transformCat((Function)new Function<Interval, Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>>>(){

            public Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>> apply(Interval input) {
                return timeline.lookup(input);
            }
        }).transformCat(new Function<TimelineObjectHolder<String, ReferenceCountingSegment>, Iterable<QueryRunner<T>>>(){

            public Iterable<QueryRunner<T>> apply(final @Nullable TimelineObjectHolder<String, ReferenceCountingSegment> holder) {
                if (holder == null) {
                    return null;
                }
                return FunctionalIterable.create((Iterable)holder.getObject()).transform(new Function<PartitionChunk<ReferenceCountingSegment>, QueryRunner<T>>(){

                    public QueryRunner<T> apply(PartitionChunk<ReferenceCountingSegment> input) {
                        return ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, (ReferenceCountingSegment)input.getObject(), (QuerySegmentSpec)new SpecificSegmentSpec(new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), input.getChunkNumber())));
                    }
                }).filter(Predicates.notNull());
            }
        }).filter(Predicates.notNull());
        return new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, (Iterable)adapters)), toolChest);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            log.makeAlert("Unknown query type, [%s]", new Object[]{query.getClass()}).addData("dataSource", (Object)query.getDataSource()).emit();
            return new NoopQueryRunner();
        }
        final QueryToolChest toolChest = factory.getToolchest();
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.dataSources.get(query.getDataSource());
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        FunctionalIterable adapters = FunctionalIterable.create(specs).transformCat(new Function<SegmentDescriptor, Iterable<QueryRunner<T>>>(){

            public Iterable<QueryRunner<T>> apply(SegmentDescriptor input) {
                PartitionHolder entry = timeline.findEntry(input.getInterval(), (Object)input.getVersion());
                if (entry == null) {
                    return null;
                }
                PartitionChunk chunk = entry.getChunk(input.getPartitionNumber());
                if (chunk == null) {
                    return null;
                }
                ReferenceCountingSegment adapter = (ReferenceCountingSegment)chunk.getObject();
                return Arrays.asList(ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, adapter, (QuerySegmentSpec)new SpecificSegmentSpec(input)));
            }
        }).filter(Predicates.notNull());
        return new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, (Iterable)adapters)), toolChest);
    }

    private <T> QueryRunner<T> buildAndDecorateQueryRunner(QueryRunnerFactory<T, Query<T>> factory, final QueryToolChest<T, Query<T>> toolChest, ReferenceCountingSegment adapter, QuerySegmentSpec segmentSpec) {
        return new SpecificSegmentQueryRunner((QueryRunner)new MetricsEmittingQueryRunner(this.emitter, new Function<Query<T>, ServiceMetricEvent.Builder>(){

            public ServiceMetricEvent.Builder apply(@Nullable Query<T> input) {
                return toolChest.makeMetricBuilder(input);
            }
        }, (QueryRunner)new BySegmentQueryRunner(adapter.getIdentifier(), adapter.getDataInterval().getStart(), (QueryRunner)new ReferenceCountingSegmentQueryRunner(factory, adapter))).withWaitMeasuredFromNow(), segmentSpec);
    }
}

