/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.curator.announcement.Announcer;
import io.druid.server.coordination.AbstractDataSegmentAnnouncer;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.initialization.BatchDataSegmentAnnouncerConfig;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.curator.utils.ZKPaths;
import org.joda.time.DateTime;

public class BatchDataSegmentAnnouncer
extends AbstractDataSegmentAnnouncer {
    private static final Logger log = new Logger(BatchDataSegmentAnnouncer.class);
    private final BatchDataSegmentAnnouncerConfig config;
    private final Announcer announcer;
    private final ObjectMapper jsonMapper;
    private final String liveSegmentLocation;
    private final Object lock = new Object();
    private final AtomicLong counter = new AtomicLong(0L);
    private final Set<SegmentZNode> availableZNodes = new ConcurrentSkipListSet<SegmentZNode>();
    private final Map<DataSegment, SegmentZNode> segmentLookup = Maps.newConcurrentMap();

    @Inject
    public BatchDataSegmentAnnouncer(DruidServerMetadata server, BatchDataSegmentAnnouncerConfig config, ZkPathsConfig zkPaths, Announcer announcer, ObjectMapper jsonMapper) {
        super(server, zkPaths, announcer, jsonMapper);
        this.config = config;
        this.announcer = announcer;
        this.jsonMapper = jsonMapper;
        this.liveSegmentLocation = ZKPaths.makePath((String)zkPaths.getLiveSegmentsPath(), (String)server.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announceSegment(DataSegment segment) throws IOException {
        int newBytesLen = this.jsonMapper.writeValueAsBytes((Object)segment).length;
        if ((long)newBytesLen > this.config.getMaxBytesPerNode()) {
            throw new ISE("byte size %,d exceeds %,d", new Object[]{newBytesLen, this.config.getMaxBytesPerNode()});
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.availableZNodes.isEmpty()) {
                SegmentZNode availableZNode = new SegmentZNode(this.makeServedSegmentPath(new DateTime().toString()));
                availableZNode.addSegment(segment);
                log.info("Announcing segment[%s] at path[%s]", new Object[]{segment.getIdentifier(), availableZNode.getPath()});
                this.announcer.announce(availableZNode.getPath(), availableZNode.getBytes());
                this.segmentLookup.put(segment, availableZNode);
                this.availableZNodes.add(availableZNode);
            } else {
                Iterator<SegmentZNode> iter = this.availableZNodes.iterator();
                boolean done = false;
                while (iter.hasNext() && !done) {
                    SegmentZNode availableZNode = iter.next();
                    if ((long)(availableZNode.getBytes().length + newBytesLen) >= this.config.getMaxBytesPerNode()) continue;
                    availableZNode.addSegment(segment);
                    log.info("Announcing segment[%s] at path[%s]", new Object[]{segment.getIdentifier(), availableZNode.getPath()});
                    this.announcer.update(availableZNode.getPath(), availableZNode.getBytes());
                    this.segmentLookup.put(segment, availableZNode);
                    if (availableZNode.getCount() >= this.config.getSegmentsPerNode()) {
                        this.availableZNodes.remove(availableZNode);
                    }
                    done = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unannounceSegment(DataSegment segment) throws IOException {
        SegmentZNode segmentZNode = this.segmentLookup.remove(segment);
        if (segmentZNode == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            segmentZNode.removeSegment(segment);
            log.info("Unannouncing segment[%s] at path[%s]", new Object[]{segment.getIdentifier(), segmentZNode.getPath()});
            if (segmentZNode.getCount() == 0) {
                this.availableZNodes.remove(segmentZNode);
                this.announcer.unannounce(segmentZNode.getPath());
            } else {
                this.announcer.update(segmentZNode.getPath(), segmentZNode.getBytes());
                this.availableZNodes.add(segmentZNode);
            }
        }
    }

    @Override
    public void announceSegments(Iterable<DataSegment> segments) throws IOException {
        SegmentZNode segmentZNode = new SegmentZNode(this.makeServedSegmentPath(new DateTime().toString()));
        HashSet batch = Sets.newHashSet();
        int byteSize = 0;
        int count = 0;
        for (DataSegment segment : segments) {
            int newBytesLen = this.jsonMapper.writeValueAsBytes((Object)segment).length;
            if ((long)newBytesLen > this.config.getMaxBytesPerNode()) {
                throw new ISE("byte size %,d exceeds %,d", new Object[]{newBytesLen, this.config.getMaxBytesPerNode()});
            }
            if (count >= this.config.getSegmentsPerNode() || (long)(byteSize + newBytesLen) > this.config.getMaxBytesPerNode()) {
                segmentZNode.addSegments(batch);
                this.announcer.announce(segmentZNode.getPath(), segmentZNode.getBytes());
                segmentZNode = new SegmentZNode(this.makeServedSegmentPath(new DateTime().toString()));
                batch = Sets.newHashSet();
                count = 0;
                byteSize = 0;
            }
            log.info("Announcing segment[%s] at path[%s]", new Object[]{segment.getIdentifier(), segmentZNode.getPath()});
            this.segmentLookup.put(segment, segmentZNode);
            batch.add(segment);
            ++count;
            byteSize += newBytesLen;
        }
        segmentZNode.addSegments(batch);
        this.announcer.announce(segmentZNode.getPath(), segmentZNode.getBytes());
    }

    @Override
    public void unannounceSegments(Iterable<DataSegment> segments) throws IOException {
        for (DataSegment segment : segments) {
            this.unannounceSegment(segment);
        }
    }

    private String makeServedSegmentPath(String zNode) {
        return ZKPaths.makePath((String)this.liveSegmentLocation, (String)String.format("%s%s", zNode, this.counter.getAndIncrement()));
    }

    private class SegmentZNode
    implements Comparable<SegmentZNode> {
        private final String path;
        private byte[] bytes = new byte[0];
        private int count = 0;

        public SegmentZNode(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public int getCount() {
            return this.count;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public Set<DataSegment> getSegments() {
            if (this.bytes.length == 0) {
                return Sets.newHashSet();
            }
            try {
                return (Set)BatchDataSegmentAnnouncer.this.jsonMapper.readValue(this.bytes, (TypeReference)new TypeReference<Set<DataSegment>>(){});
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void addSegment(DataSegment segment) {
            Set<DataSegment> zkSegments = this.getSegments();
            zkSegments.add(segment);
            try {
                this.bytes = BatchDataSegmentAnnouncer.this.jsonMapper.writeValueAsBytes(zkSegments);
            }
            catch (Exception e) {
                zkSegments.remove(segment);
                throw Throwables.propagate((Throwable)e);
            }
            ++this.count;
        }

        public void addSegments(Set<DataSegment> segments) {
            Set<DataSegment> zkSegments = this.getSegments();
            zkSegments.addAll(segments);
            try {
                this.bytes = BatchDataSegmentAnnouncer.this.jsonMapper.writeValueAsBytes(zkSegments);
            }
            catch (Exception e) {
                zkSegments.removeAll(segments);
                throw Throwables.propagate((Throwable)e);
            }
            this.count += segments.size();
        }

        public void removeSegment(DataSegment segment) {
            Set<DataSegment> zkSegments = this.getSegments();
            zkSegments.remove(segment);
            try {
                this.bytes = BatchDataSegmentAnnouncer.this.jsonMapper.writeValueAsBytes(zkSegments);
            }
            catch (Exception e) {
                zkSegments.add(segment);
                throw Throwables.propagate((Throwable)e);
            }
            --this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SegmentZNode that = (SegmentZNode)o;
            return this.path.equals(that.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        @Override
        public int compareTo(SegmentZNode segmentZNode) {
            return this.path.compareTo(segmentZNode.getPath());
        }
    }
}

