/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.bridge;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.client.DruidServer;
import io.druid.client.ServerView;
import io.druid.concurrent.Execs;
import io.druid.db.DatabaseSegmentManager;
import io.druid.segment.realtime.DbSegmentPublisher;
import io.druid.server.bridge.Bridge;
import io.druid.server.coordination.BaseZkCoordinator;
import io.druid.server.coordination.DataSegmentChangeCallback;
import io.druid.server.coordination.DataSegmentChangeHandler;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;

public class BridgeZkCoordinator
extends BaseZkCoordinator {
    private static final Logger log = new Logger(BaseZkCoordinator.class);
    private final DbSegmentPublisher dbSegmentPublisher;
    private final DatabaseSegmentManager databaseSegmentManager;
    private final ServerView serverView;
    private final ExecutorService exec = Execs.singleThreaded((String)"BridgeZkCoordinatorServerView-%s");

    @Inject
    public BridgeZkCoordinator(ObjectMapper jsonMapper, ZkPathsConfig zkPaths, DruidServerMetadata me, @Bridge CuratorFramework curator, DbSegmentPublisher dbSegmentPublisher, DatabaseSegmentManager databaseSegmentManager, ServerView serverView) {
        super(jsonMapper, zkPaths, me, curator);
        this.dbSegmentPublisher = dbSegmentPublisher;
        this.databaseSegmentManager = databaseSegmentManager;
        this.serverView = serverView;
    }

    @Override
    public void loadLocalCache() {
    }

    @Override
    public DataSegmentChangeHandler getDataSegmentChangeHandler() {
        return this;
    }

    @Override
    public void addSegment(final DataSegment segment, final DataSegmentChangeCallback callback) {
        try {
            log.info("Publishing segment %s", new Object[]{segment.getIdentifier()});
            this.dbSegmentPublisher.publishSegment(segment);
            this.serverView.registerSegmentCallback(this.exec, new ServerView.BaseSegmentCallback(){

                @Override
                public ServerView.CallbackAction segmentAdded(DruidServer server, DataSegment theSegment) {
                    if (theSegment.equals((Object)segment)) {
                        callback.execute();
                    }
                    return ServerView.CallbackAction.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void removeSegment(final DataSegment segment, final DataSegmentChangeCallback callback) {
        this.databaseSegmentManager.removeSegment(segment.getDataSource(), segment.getIdentifier());
        this.serverView.registerSegmentCallback(this.exec, new ServerView.BaseSegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServer server, DataSegment theSegment) {
                if (theSegment.equals((Object)segment)) {
                    callback.execute();
                }
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }
}

