/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import io.druid.query.Query;
import java.util.Arrays;
import org.joda.time.DateTime;

public class RequestLogLine {
    private static final Joiner JOINER = Joiner.on((String)"\t");
    private final DateTime timestamp;
    private final String remoteAddr;
    private final Query query;

    public RequestLogLine(DateTime timestamp, String remoteAddr, Query query) {
        this.timestamp = timestamp;
        this.remoteAddr = remoteAddr;
        this.query = query;
    }

    public String getLine(ObjectMapper objectMapper) throws JsonProcessingException {
        return JOINER.join(Arrays.asList(this.timestamp, this.remoteAddr, objectMapper.writeValueAsString((Object)this.query)));
    }

    @JsonProperty(value="timestamp")
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="query")
    public Query getQuery() {
        return this.query;
    }

    @JsonProperty(value="remoteAddr")
    public String getRemoteAddr() {
        return this.remoteAddr;
    }
}

