/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.inject.Inject;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.AlertEvent;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.query.Query;
import io.druid.query.QuerySegmentWalker;
import io.druid.server.RequestLogLine;
import io.druid.server.log.RequestLogger;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.joda.time.DateTime;

@Path(value="/druid/v2/")
public class QueryResource {
    private static final Logger log = new Logger(QueryResource.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final QuerySegmentWalker texasRanger;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;

    @Inject
    public QueryResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QuerySegmentWalker texasRanger, ServiceEmitter emitter, RequestLogger requestLogger) {
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.texasRanger = texasRanger;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    public void doPost(@Context HttpServletRequest req, @Context HttpServletResponse resp) throws ServletException, IOException {
        long start = System.currentTimeMillis();
        Object query = null;
        byte[] requestQuery = null;
        boolean isSmile = "application/smile".equals(req.getContentType());
        ObjectMapper objectMapper = isSmile ? this.smileMapper : this.jsonMapper;
        ObjectWriter jsonWriter = req.getParameter("pretty") == null ? objectMapper.writer() : objectMapper.writerWithDefaultPrettyPrinter();
        ServletOutputStream out = null;
        try {
            requestQuery = ByteStreams.toByteArray((InputStream)req.getInputStream());
            query = (Query)objectMapper.readValue(requestQuery, Query.class);
            this.requestLogger.log(new RequestLogLine(new DateTime(), req.getRemoteAddr(), (Query)query));
            Sequence results = query.run(this.texasRanger);
            if (results == null) {
                results = Sequences.empty();
            }
            resp.setStatus(200);
            resp.setContentType("application/x-javascript");
            out = resp.getOutputStream();
            jsonWriter.writeValue((OutputStream)out, (Object)results);
            long requestTime = System.currentTimeMillis() - start;
            this.emitter.emit(new ServiceMetricEvent.Builder().setUser2(query.getDataSource()).setUser4(query.getType()).setUser5(query.getIntervals().get(0).toString()).setUser6(String.valueOf(query.hasFilters())).setUser7(req.getRemoteAddr()).setUser9(query.getDuration().toPeriod().toStandardMinutes().toString()).build("request/time", (Number)requestTime));
        }
        catch (Exception e) {
            try {
                String queryString = query == null ? (isSmile ? "smile_unknown" : new String(requestQuery, Charsets.UTF_8)) : query.toString();
                log.warn((Throwable)e, "Exception occurred on request [%s]", new Object[]{queryString});
                if (!resp.isCommitted()) {
                    resp.setStatus(500);
                    resp.resetBuffer();
                    if (out == null) {
                        out = resp.getOutputStream();
                    }
                    out.write(e.getMessage() == null ? "Exception null".getBytes(UTF8) : e.getMessage().getBytes(UTF8));
                    out.write("\n".getBytes(UTF8));
                }
                resp.flushBuffer();
                this.emitter.emit(new AlertEvent.Builder().build("Exception handling request", (Map)ImmutableMap.builder().put((Object)"exception", (Object)e.toString()).put((Object)"query", (Object)queryString).put((Object)"peer", (Object)req.getRemoteAddr()).build()));
            }
            catch (Throwable throwable) {
                resp.flushBuffer();
                Closeables.closeQuietly(out);
                throw throwable;
            }
            resp.flushBuffer();
            Closeables.closeQuietly((Closeable)out);
        }
        resp.flushBuffer();
        Closeables.closeQuietly((Closeable)out);
    }
}

