/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.common.utils.SocketUtil;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class DruidNode {
    private String hostNoPort;
    @JsonProperty(value="service")
    @NotNull
    private String serviceName = null;
    @JsonProperty
    @NotNull
    private String host = null;
    @JsonProperty
    @Min(value=0L)
    @Max(value=65535L)
    private int port = -1;

    @JsonCreator
    public DruidNode(@JsonProperty(value="service") String serviceName, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port) {
        this.serviceName = serviceName;
        if (port == null) {
            if (host == null) {
                this.setHostAndPort(null, -1, null);
            } else if (host.contains(":")) {
                String[] hostParts = host.split(":");
                try {
                    this.setHostAndPort(host, Integer.parseInt(hostParts[1]), hostParts[0]);
                }
                catch (NumberFormatException e) {
                    this.setHostAndPort(host, -1, hostParts[0]);
                }
            } else {
                int openPort = SocketUtil.findOpenPort((int)8080);
                this.setHostAndPort(String.format("%s:%d", host, openPort), openPort, host);
            }
        } else if (host == null || host.contains(":")) {
            this.setHostAndPort(host, port, host == null ? null : host.split(":")[0]);
        } else {
            this.setHostAndPort(String.format("%s:%d", host, port), port, host);
        }
    }

    private void setHostAndPort(String host, int port, String hostNoPort) {
        this.host = host;
        this.port = port;
        this.hostNoPort = hostNoPort;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostNoPort() {
        return this.hostNoPort;
    }

    public String toString() {
        return "DruidNode{serviceName='" + this.serviceName + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

