/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.google.common.base.Function;
import com.google.inject.Inject;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.client.CachingClusteredClient;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.MetricsEmittingQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.query.SegmentDescriptor;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class ClientQuerySegmentWalker
implements QuerySegmentWalker {
    private final ServiceEmitter emitter;
    private final CachingClusteredClient baseClient;
    private final QueryToolChestWarehouse warehouse;

    @Inject
    public ClientQuerySegmentWalker(ServiceEmitter emitter, CachingClusteredClient baseClient, QueryToolChestWarehouse warehouse) {
        this.emitter = emitter;
        this.baseClient = baseClient;
        this.warehouse = warehouse;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.makeRunner(query);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.makeRunner(query);
    }

    private <T> FinalizeResultsQueryRunner<T> makeRunner(final Query<T> query) {
        final QueryToolChest toolChest = this.warehouse.getToolChest(query);
        return new FinalizeResultsQueryRunner(toolChest.postMergeQueryDecoration(toolChest.mergeResults((QueryRunner)new MetricsEmittingQueryRunner(this.emitter, new Function<Query<T>, ServiceMetricEvent.Builder>(){

            public ServiceMetricEvent.Builder apply(@Nullable Query<T> input) {
                return toolChest.makeMetricBuilder(query);
            }
        }, toolChest.preMergeQueryDecoration((QueryRunner)this.baseClient)).withWaitMeasuredFromNow())), toolChest);
    }
}

