/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.druid.client.DruidDataSource;
import io.druid.client.DruidServer;
import io.druid.client.InventoryView;
import io.druid.timeline.DataSegment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

@Path(value="/druid/v2/datasources")
public class ClientInfoResource {
    private static final int SEGMENT_HISTORY_MILLIS = 604800000;
    private InventoryView serverInventoryView;

    @Inject
    public ClientInfoResource(InventoryView serverInventoryView) {
        this.serverInventoryView = serverInventoryView;
    }

    private Map<String, List<DataSegment>> getSegmentsForDatasources() {
        HashMap dataSourceMap = Maps.newHashMap();
        for (DruidServer server : this.serverInventoryView.getInventory()) {
            for (DruidDataSource dataSource : server.getDataSources()) {
                if (!dataSourceMap.containsKey(dataSource.getName())) {
                    dataSourceMap.put(dataSource.getName(), Lists.newArrayList());
                }
                List segments = (List)dataSourceMap.get(dataSource.getName());
                segments.addAll(dataSource.getSegments());
            }
        }
        return dataSourceMap;
    }

    @GET
    @Produces(value={"application/json"})
    public Iterable<String> getDataSources() {
        return this.getSegmentsForDatasources().keySet();
    }

    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    public Map<String, Object> getDatasource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval) {
        return ImmutableMap.of((Object)"dimensions", this.getDatasourceDimensions(dataSourceName, interval), (Object)"metrics", this.getDatasourceMetrics(dataSourceName, interval));
    }

    @GET
    @Path(value="/{dataSourceName}/dimensions")
    @Produces(value={"application/json"})
    public Iterable<String> getDatasourceDimensions(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval) {
        Interval theInterval;
        List<DataSegment> segments = this.getSegmentsForDatasources().get(dataSourceName);
        if (interval == null || interval.isEmpty()) {
            DateTime now = new DateTime();
            theInterval = new Interval((ReadableInstant)now.minusMillis(604800000), (ReadableInstant)now);
        } else {
            theInterval = new Interval((Object)interval);
        }
        HashSet dims = Sets.newHashSet();
        for (DataSegment segment : segments) {
            if (!theInterval.overlaps((ReadableInterval)segment.getInterval())) continue;
            dims.addAll(segment.getDimensions());
        }
        return dims;
    }

    @GET
    @Path(value="/{dataSourceName}/metrics")
    @Produces(value={"application/json"})
    public Iterable<String> getDatasourceMetrics(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval) {
        Interval theInterval;
        List<DataSegment> segments = this.getSegmentsForDatasources().get(dataSourceName);
        if (interval == null || interval.isEmpty()) {
            DateTime now = new DateTime();
            theInterval = new Interval((ReadableInstant)now.minusMillis(604800000), (ReadableInstant)now);
        } else {
            theInterval = new Interval((Object)interval);
        }
        HashSet metrics = Sets.newHashSet();
        for (DataSegment segment : segments) {
            if (!theInterval.overlaps((ReadableInterval)segment.getInterval())) continue;
            metrics.addAll(segment.getMetrics());
        }
        return metrics;
    }
}

